/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.validate.factory;

import com.bxm.warcar.validate.Validator;
import com.google.common.collect.Maps;

import java.util.List;
import java.util.Map;

public class PreGeneratedValidatorFactory implements ValidatorFactory {

	private final Map<Class<?>, Validator> validators;

	public PreGeneratedValidatorFactory(ValidatorFactory validatorFactory,
                                        List<Class<?>> modelClasses) {
		if (null == validatorFactory)
			throw new NullPointerException("validatorFactory");
		if (null == modelClasses || modelClasses.isEmpty())
			throw new IllegalArgumentException("Validate modelClasses is blank.");

		validators = Maps.newHashMap();
		for (Class<?> modelClass : modelClasses) {
			Validator validator = validatorFactory.create(modelClass);
			validators.put(modelClass, validator);
		}
	}

	@Override
	public Validator create(Class<?> beanClass) {
		if (null == beanClass)
			throw new NullPointerException("beanClass");
		return validators.get(beanClass);
	}
}
