/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.validate.internal;


import com.bxm.warcar.validate.CompareValidator;
import com.bxm.warcar.validate.ConstraintViolationException;
import com.bxm.warcar.validate.ValidateException;

import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;


public class NotLaterThanValidator extends CompareValidator {

	private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	public NotLaterThanValidator(Field field, Field compareField) {
		super(field, compareField);
	}

	@Override
	protected void doValidate(Object input) throws Exception {
		Object _v0 = getValue(input);
		if (!(_v0 instanceof Date))
			throw new ValidateException("Expect Date,but " + _v0);
		Date v0 = (Date) _v0;

		Object _v1 = getCompareValue(input);
		if (!(_v1 instanceof Date))
			throw new ValidateException("Expect Date,but " + _v1);
		Date v1 = (Date) _v1;

		if (v0.getTime() > v1.getTime()) {
			throw new ConstraintViolationException(this, FORMAT.format(v0) + ","
					+ FORMAT.format(v1));
		}
	}

	@Override
	public String getConstraintDesc() {
		return new StringBuilder(64).append(getFieldDesc()).append(" must not be later than ")
				.append(getCompareField()).toString();
	}
}
