/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.configure.loader;

import com.bxm.warcar.configure.EnvironmentLoader;
import com.bxm.warcar.configure.PropertiesReader;
import com.bxm.warcar.configure.reader.PropertiesReaderFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractEnvironmentLoader
implements EnvironmentLoader {
    protected final String addresses;
    protected final String[] keys;

    public AbstractEnvironmentLoader(String address, String[] keys) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)address));
        Preconditions.checkArgument((null != keys ? 1 : 0) != 0);
        this.addresses = address;
        this.keys = keys;
    }

    protected abstract byte[] readSource(String var1);

    @Override
    public List<Properties> loadProperties() {
        ArrayList properties = Lists.newArrayList();
        for (String key : this.keys) {
            byte[] bytes = this.readSource(key);
            if (null == bytes || bytes.length == 0) continue;
            PropertiesReader reader = PropertiesReaderFactory.create(key);
            properties.add(reader.read(bytes));
        }
        return properties;
    }
}

