/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils.http.pool;

import com.bxm.warcar.utils.http.HttpClientUtils;
import com.bxm.warcar.utils.http.HttpPool;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.bxm.warcar.utils.http.properties.HttpProperties;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class HttpClientPool
implements HttpPool {
    private final CloseableHttpClient httpClient;
    private final RequestConfig requestConfig;

    public HttpClientPool(HttpProperties properties) {
        PlainConnectionSocketFactory plainsf = PlainConnectionSocketFactory.getSocketFactory();
        SSLConnectionSocketFactory sslsf = SSLConnectionSocketFactory.getSocketFactory();
        Registry registry = RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sslsf).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(registry);
        connManager.setMaxTotal(properties.getMaxTotal());
        connManager.setDefaultMaxPerRoute(properties.getDefaultMaxPerRoute());
        this.requestConfig = RequestConfig.custom().setConnectionRequestTimeout(properties.getConnectionRequestTimeout()).setConnectTimeout(properties.getConnectTimeout()).setSocketTimeout(properties.getSocketTimeout()).setExpectContinueEnabled(false).build();
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
    }

    @Override
    public String get(String url) {
        return this.get(url, Maps.newHashMap());
    }

    @Override
    public String get(String url, Map<String, String> headers) {
        return this.get(url, Maps.newHashMap(), headers);
    }

    @Override
    public String get(String url, Map<String, Object> params, Map<String, String> headers) {
        HttpGet httpGet = new HttpGet(OkHttpUtils.appendParams(url, params));
        HttpClientUtils.setHeader((HttpRequestBase)httpGet, headers);
        return this.doRequest((HttpRequestBase)httpGet, headers);
    }

    @Override
    public String post(String url) {
        return this.post(url, Maps.newHashMap(), Maps.newHashMap());
    }

    @Override
    public String post(String url, Map<String, Object> params) {
        return this.post(url, params, Maps.newHashMap());
    }

    @Override
    public String post(String url, Map<String, Object> params, Map<String, String> headers) {
        HttpPost httpPost = new HttpPost(url);
        HttpClientUtils.setParams(httpPost, params);
        return this.doRequest((HttpRequestBase)httpPost, headers);
    }

    @Override
    public String postRequestBody(String url, Object o, Map<String, String> headers) {
        HttpPost httpPost = new HttpPost(url);
        HttpClientUtils.setRequestBody(httpPost, o);
        return this.doRequest((HttpRequestBase)httpPost, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doRequest(HttpRequestBase httpReq, Map<String, String> headers) {
        CloseableHttpResponse httpResp = null;
        try {
            httpReq.setConfig(this.requestConfig);
            HttpClientUtils.setHeader(httpReq, headers);
            httpResp = this.httpClient.execute((HttpUriRequest)httpReq);
            String string = EntityUtils.toString((HttpEntity)httpResp.getEntity());
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (httpResp != null) {
                    httpResp.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

