/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils.http.pool;

import com.bxm.warcar.utils.http.HttpMethod;
import com.bxm.warcar.utils.http.HttpPool;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.bxm.warcar.utils.http.properties.HttpProperties;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpPool
implements HttpPool {
    private OkHttpClient mOkHttpClient;

    public OkHttpPool(HttpProperties httpProperties) {
        this.mOkHttpClient = new OkHttpClient.Builder().connectTimeout((long)httpProperties.getConnectTimeout(), TimeUnit.SECONDS).readTimeout((long)httpProperties.getSocketTimeout(), TimeUnit.SECONDS).connectionPool(new ConnectionPool(httpProperties.getMaxTotal(), (long)httpProperties.getDefaultMaxPerRoute(), TimeUnit.MINUTES)).build();
    }

    @Override
    public String get(String url) throws IOException {
        return OkHttpUtils.packagingResult(this.getRequest(url));
    }

    @Override
    public String get(String url, Map<String, String> headers) throws IOException {
        return OkHttpUtils.packagingResult(this.request(url, HttpMethod.GET, headers));
    }

    @Override
    public String get(String url, Map<String, Object> params, Map<String, String> headers) throws IOException {
        return this.get(OkHttpUtils.appendParams(url, params), headers);
    }

    @Override
    public String post(String url) throws IOException {
        return this.post(url, Maps.newHashMap());
    }

    @Override
    public String post(String url, Map<String, Object> params) throws IOException {
        return OkHttpUtils.packagingResult(this.postRequest(url, OkHttpUtils.buildBody(params)));
    }

    @Override
    public String post(String url, Map<String, Object> params, Map<String, String> headers) throws IOException {
        return OkHttpUtils.packagingResult(this.request(url, HttpMethod.POST, OkHttpUtils.buildBody(params), headers));
    }

    @Override
    public String postRequestBody(String url, Object o, Map<String, String> headers) throws IOException {
        return OkHttpUtils.packagingResult(this.requestBody(url, HttpMethod.POST, OkHttpUtils.buildRequestBody(o), headers));
    }

    public Response postRequest(String url, RequestBody body) throws IOException {
        return this.request(url, HttpMethod.POST, body);
    }

    public Response getRequest(String url) throws IOException {
        return this.request(url, HttpMethod.GET);
    }

    public Response request(String url, HttpMethod method) throws IOException {
        return this.request(url, method, Maps.newHashMap());
    }

    public Response request(String url, HttpMethod method, Map<String, String> headers) throws IOException {
        return this.request(url, method, null, headers);
    }

    public Response request(String url, HttpMethod method, RequestBody body) throws IOException {
        return this.request(url, method, body, null);
    }

    public Response request(String url, HttpMethod method, RequestBody body, Map<String, String> headers) throws IOException {
        return this.mOkHttpClient.newCall(OkHttpUtils.setHeaders(OkHttpUtils.buildRequest(url, method, body), headers).build()).execute();
    }

    public Response requestBody(String url, HttpMethod method, RequestBody body, Map<String, String> headers) throws IOException {
        return this.mOkHttpClient.newCall(OkHttpUtils.setHeaders(OkHttpUtils.buildRequest(url, method, body), headers).build()).execute();
    }
}

