/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.voice.submail;

import com.alibaba.fastjson.JSON;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * <h3>Voice sender</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/02/12 10:58
 */
public class Voice implements Serializable {

    private static final long serialVersionUID = 7953257301233581347L;

    private List<Entity> multi =  new ArrayList<>();

    /**
     * 直接添加一个手机号码
     * 如：
     * Voice vocie =new Voice();
     * vocie.addMulti("10086");
     * @param to 手机号码
     * @return Voice
     */
    public Voice addMulti(String to){
        this.multi.add(new Entity(to));
        return this;
    }
    public Voice(){}

    public Voice(List<Entity> multi) {
        this.multi = multi;
    }

    public List<Entity> getMulti() {
        return multi;
    }

    public void setMulti(List<Entity> multi) {
        this.multi = multi;
    }

    class Entity implements Serializable {
        private static final long serialVersionUID = 7072302303292359707L;
        private String to;

        public Entity(String to) {
            this.to = to;
        }

        public String getTo() {
            return to;
        }

        public void setTo(String to) {
            this.to = to;
        }
    }

    @Override
    public String toString() {
        return  JSON.toJSONString(multi);
    }
}
