package com.bxm.warcar.integration.sifter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import com.google.common.collect.Maps;

/**
 * 筛选消息<br/>
 *
 * @author kerry.jiang
 * @date 2020/03/24 18:11
 */
public class SifterMessage implements java.io.Serializable {

    private static final long serialVersionUID = 88L;

    /**
     * 通过的ID列表
     */
    private List<String> passIdList = new ArrayList<>();
    /**
     * 不通过的ID列表
     */
    private List<String> noPassIdList = new ArrayList<>();
    /**
     * 筛选者->被过滤的原因->ID列表
     */
    private Map<String, Map<String, List<String>>> reason = Maps.newHashMap();

    public List<String> getPassIdList() {
        return passIdList;
    }

    public void setPassIdList(List<String> passIdList) {
        this.passIdList = passIdList;
    }

    public List<String> getNoPassIdList() {
        return noPassIdList;
    }

    public void setNoPassIdList(List<String> noPassIdList) {
        this.noPassIdList = noPassIdList;
    }

    public Map<String, Map<String, List<String>>> getReason() {
        return reason;
    }

    public void setReason(Map<String, Map<String, List<String>>> reason) {
        this.reason = reason;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
}
