package com.bxm.warcar.xcache;


import org.apache.commons.collections.KeyValue;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 获取器
 *
 * @author allen
 * @date 2019/1/7
 * @since 1.0.0
 */
public interface Fetcher {

    /**
     * 获取一个对象
     * @param target 目标
     * @param <T> 对象类型
     * @return 对象
     */
    <T> T fetch(Target<T> target);

    /**
     * 获取一个对象集合
     * @param target 目标
     * @param <T> 对象类型
     * @return 对象集合
     */
    <T> List<T> fetchToList(Target<T> target);

    /**
     * 从 hash 结构的存储中获取一个对象
     * @param target 目标
     * @param <T> 对象类型
     * @return 对象
     */
    <T> T hfetch(Target<T> target);

    /**
     * 从 hash 结构的存储中获取一个对象集合
     * @param target 目标
     * @param <T> 对象类型
     * @return 对象集合
     */
    <T> List<T> hfetchToList(Target<T> target);

    /**
     * 获取 hash 结构中存储的所有对象
     * @param target 目标
     * @param <T> 对象类型
     * @return 对象集合
     */
    <T> Map<String, T> hfetchall(Target<T> target);

    /**
     * 获取 Set 结构中存储的所有对象
     * @param target 目标
     * @param <T> 对象类型
     * @return 对象集合
     */
    <T> Set<T> sfetchall(Target<T> target);

    /**
     * 从 SortedSet 结构的存储中获取一个对象集合
     * @param target 目标
     * @param <T> 对象类型
     * @return 对象集合
     */
    <T> List<T> zfetch(Target<T> target);

    /**
     * 从 SortedSet 结构的存储中获取一个键值对集合
     * @param target 目标
     * @param <T> 对象类型，也是键值对中的键的类型
     * @return 键值对集合
     */
    <T> List<KeyValue> zfetchall(Target<T> target);

    <T> long distinct(Target<T> target);

    /**
     * 返回这个获取器具体的原生客户端实现
     * @param <T> 类型
     * @return 实现
     */
    <T> T getClientOriginal();
}
