/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.DirtyState;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.Lint;
import com.diffplug.spotless.LintSuppression;
import com.diffplug.spotless.ValuePerStep;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;

public class LintState {
    private final DirtyState dirtyState;
    @Nullable
    private final List<List<Lint>> lintsPerStep;
    private static final LintState isClean = new LintState(DirtyState.clean(), null);

    LintState(DirtyState dirtyState, @Nullable List<List<Lint>> lintsPerStep) {
        this.dirtyState = dirtyState;
        this.lintsPerStep = lintsPerStep;
    }

    public DirtyState getDirtyState() {
        return this.dirtyState;
    }

    public boolean isHasLints() {
        return this.lintsPerStep != null;
    }

    public boolean isClean() {
        return this.dirtyState.isClean() && !this.isHasLints();
    }

    public LinkedHashMap<String, List<Lint>> getLintsByStep(Formatter formatter) {
        if (this.lintsPerStep == null) {
            throw new IllegalStateException("Check `isHasLints` first!");
        }
        if (this.lintsPerStep.size() != formatter.getSteps().size()) {
            throw new IllegalStateException("LintState was created with a different formatter!");
        }
        LinkedHashMap<String, List<Lint>> result = new LinkedHashMap<String, List<Lint>>();
        for (int i = 0; i < this.lintsPerStep.size(); ++i) {
            List<Lint> lints = this.lintsPerStep.get(i);
            if (lints == null) continue;
            FormatterStep step = formatter.getSteps().get(i);
            result.put(step.getName(), lints);
        }
        return result;
    }

    public LintState withRemovedSuppressions(Formatter formatter, String relativePath, List<LintSuppression> suppressions) {
        if (this.lintsPerStep == null) {
            return this;
        }
        if (formatter.getSteps().size() != this.lintsPerStep.size()) {
            throw new IllegalStateException("LintState was created with a different formatter!");
        }
        boolean changed = false;
        ValuePerStep<List<Lint>> perStepFiltered = new ValuePerStep<List<Lint>>(formatter);
        for (int i = 0; i < this.lintsPerStep.size(); ++i) {
            FormatterStep step = formatter.getSteps().get(i);
            List<Lint> lintsOriginal = this.lintsPerStep.get(i);
            if (lintsOriginal == null) continue;
            ArrayList<Lint> lints = new ArrayList<Lint>(lintsOriginal);
            Iterator iter = lints.iterator();
            block1: while (iter.hasNext()) {
                Lint lint = (Lint)iter.next();
                for (LintSuppression suppression : suppressions) {
                    if (!suppression.suppresses(relativePath, step, lint)) continue;
                    changed = true;
                    iter.remove();
                    continue block1;
                }
            }
            if (lints.isEmpty()) continue;
            perStepFiltered.set(i, (List<Lint>)lints);
        }
        if (changed) {
            return new LintState(this.dirtyState, perStepFiltered.indexOfFirstValue() == -1 ? null : perStepFiltered);
        }
        return this;
    }

    public String asStringDetailed(File file, Formatter formatter) {
        return this.asString(file, formatter, false);
    }

    public String asStringOneLine(File file, Formatter formatter) {
        return this.asString(file, formatter, true);
    }

    private String asString(File file, Formatter formatter, boolean oneLine) {
        if (!this.isHasLints()) {
            return "(none)";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.lintsPerStep.size(); ++i) {
            List<Lint> lints = this.lintsPerStep.get(i);
            if (lints == null) continue;
            FormatterStep step = formatter.getSteps().get(i);
            for (Lint lint : lints) {
                result.append(file.getName()).append(":");
                lint.addWarningMessageTo(result, step.getName(), oneLine);
                result.append("\n");
            }
        }
        result.setLength(result.length() - 1);
        return result.toString();
    }

    public static LintState of(Formatter formatter, File file) throws IOException {
        return LintState.of(formatter, file, Files.readAllBytes(file.toPath()));
    }

    public static LintState of(Formatter formatter, File file, byte[] rawBytes) {
        ValuePerStep<Throwable> exceptions = new ValuePerStep<Throwable>(formatter);
        String raw = new String(rawBytes, formatter.getEncoding());
        DirtyState dirty = DirtyState.of(formatter, file, rawBytes, raw, exceptions);
        String toLint = LineEnding.toUnix(dirty.isClean() || dirty.didNotConverge() ? raw : new String(dirty.canonicalBytes(), formatter.getEncoding()));
        ValuePerStep<List<Lint>> lints = new ValuePerStep<List<Lint>>(formatter);
        for (int i = 0; i < formatter.getSteps().size(); ++i) {
            FormatterStep step = formatter.getSteps().get(i);
            Throwable exception = exceptions.get(i);
            if (exception != null && exception != LintState.formatStepCausedNoChange()) continue;
            try {
                List<Lint> lintsForStep = step.lint(toLint, file);
                if (lintsForStep == null || lintsForStep.isEmpty()) continue;
                lints.set(i, lintsForStep);
                continue;
            }
            catch (Exception e) {
                lints.set(i, List.of(Lint.createFromThrowable(step, e)));
            }
        }
        boolean nothingHasChangedSinceLast = true;
        for (int i = formatter.getSteps().size() - 1; i >= 0; --i) {
            Throwable exceptionForLint;
            FormatterStep step = formatter.getSteps().get(i);
            Throwable exception = exceptions.get(i);
            if (exception != null && exception != LintState.formatStepCausedNoChange()) {
                nothingHasChangedSinceLast = false;
            }
            if (nothingHasChangedSinceLast) {
                exceptionForLint = exceptions.get(i);
            } else {
                try {
                    step.format(toLint, file);
                    exceptionForLint = null;
                }
                catch (Throwable e) {
                    exceptionForLint = e;
                }
            }
            List<Lint> lintsForStep = exceptionForLint instanceof Lint.Has ? ((Lint.Has)((Object)exceptionForLint)).getLints() : (exceptionForLint != null && exceptionForLint != LintState.formatStepCausedNoChange() ? List.of(Lint.createFromThrowable(step, exceptionForLint)) : List.of());
            if (lintsForStep.isEmpty()) continue;
            lints.set(i, lintsForStep);
        }
        return new LintState(dirty, lints.indexOfFirstValue() == -1 ? null : lints);
    }

    public static LintState clean() {
        return isClean;
    }

    static Throwable formatStepCausedNoChange() {
        return FormatterCausedNoChange.INSTANCE;
    }

    private static class FormatterCausedNoChange
    extends Exception {
        private static final long serialVersionUID = 1L;
        static final FormatterCausedNoChange INSTANCE = new FormatterCausedNoChange();

        private FormatterCausedNoChange() {
        }
    }
}

