/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven;

import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.maven.FileLocator;
import com.diffplug.spotless.maven.FormatterStepFactory;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class FormatterConfig {
    private final String encoding;
    private final LineEnding lineEndings;
    private final Optional<String> ratchetFrom;
    private final Provisioner provisioner;
    private final FileLocator fileLocator;
    private final List<FormatterStepFactory> globalStepFactories;
    private final Optional<String> spotlessSetLicenseHeaderYearsFromGitHistory;

    public FormatterConfig(File baseDir, String encoding, LineEnding lineEndings, Optional<String> ratchetFrom, Provisioner provisioner, FileLocator fileLocator, List<FormatterStepFactory> globalStepFactories, Optional<String> spotlessSetLicenseHeaderYearsFromGitHistory) {
        this.encoding = encoding;
        this.lineEndings = lineEndings;
        this.ratchetFrom = ratchetFrom;
        this.provisioner = provisioner;
        this.fileLocator = fileLocator;
        this.globalStepFactories = globalStepFactories;
        this.spotlessSetLicenseHeaderYearsFromGitHistory = spotlessSetLicenseHeaderYearsFromGitHistory;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public LineEnding getLineEndings() {
        return this.lineEndings;
    }

    public Optional<String> getRatchetFrom() {
        return this.ratchetFrom;
    }

    public Provisioner getProvisioner() {
        return this.provisioner;
    }

    public List<FormatterStepFactory> getGlobalStepFactories() {
        return Collections.unmodifiableList(this.globalStepFactories);
    }

    public Optional<String> getSpotlessSetLicenseHeaderYearsFromGitHistory() {
        return this.spotlessSetLicenseHeaderYearsFromGitHistory;
    }

    public FileLocator getFileLocator() {
        return this.fileLocator;
    }
}

