/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.io.airlift.slice.SliceInput;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingSerde;
import com.facebook.presto.jdbc.internal.spi.block.RunLengthEncodedBlock;

public class RunLengthBlockEncoding
implements BlockEncoding {
    public static final String NAME = "RLE";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        RunLengthEncodedBlock rleBlock = (RunLengthEncodedBlock)block;
        sliceOutput.writeInt(rleBlock.getPositionCount());
        blockEncodingSerde.writeBlock(sliceOutput, rleBlock.getValue());
    }

    @Override
    public RunLengthEncodedBlock readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        Block value = blockEncodingSerde.readBlock(sliceInput);
        return new RunLengthEncodedBlock(value, positionCount);
    }
}

