/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.function;

import com.facebook.presto.jdbc.internal.spi.CatalogSchemaName;
import java.util.Objects;
import java.util.Optional;

public class CatalogSchemaPrefix {
    private final String catalogName;
    private final Optional<String> schemaName;

    public CatalogSchemaPrefix(String catalogName, Optional<String> schemaName) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
    }

    public static CatalogSchemaPrefix of(String prefix) {
        String[] parts = prefix.split("\\.");
        if (parts.length != 1 && parts.length != 2) {
            throw new IllegalArgumentException("CatalogSchemaPrefix should have 1 or 2 parts");
        }
        return parts.length == 1 ? new CatalogSchemaPrefix(parts[0], Optional.empty()) : new CatalogSchemaPrefix(parts[0], Optional.of(parts[1]));
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public Optional<String> getSchemaName() {
        return this.schemaName;
    }

    public boolean includes(CatalogSchemaName catalogSchemaName) {
        return this.catalogName.equals(catalogSchemaName.getCatalogName()) && (!this.schemaName.isPresent() || this.schemaName.get().equals(catalogSchemaName.getSchemaName()));
    }

    public boolean includes(CatalogSchemaPrefix that) {
        return this.catalogName.equals(that.getCatalogName()) && (!this.schemaName.isPresent() || that.schemaName.isPresent() && this.schemaName.get().equals(that.schemaName.get()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogSchemaPrefix that = (CatalogSchemaPrefix)o;
        return Objects.equals(this.catalogName, that.catalogName) && Objects.equals(this.schemaName, that.schemaName);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schemaName);
    }

    public String toString() {
        return this.catalogName + this.schemaName.map(name -> "." + name).orElse("");
    }
}

