/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import me.chanjar.weixin.common.api.WxErrorExceptionHandler;
import me.chanjar.weixin.common.api.WxMessageDuplicateChecker;
import me.chanjar.weixin.common.api.WxMessageInMemoryDuplicateCheckerSingleton;
import me.chanjar.weixin.common.session.InternalSession;
import me.chanjar.weixin.common.session.InternalSessionManager;
import me.chanjar.weixin.common.session.StandardSessionManager;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.common.util.LogExceptionHandler;
import me.chanjar.weixin.mp.api.WxMpMessageRouterRule;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.util.WxMpConfigStorageHolder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMpMessageRouter {
    private static final Logger log = LoggerFactory.getLogger(WxMpMessageRouter.class);
    private static final int DEFAULT_THREAD_POOL_SIZE = 100;
    private final List<WxMpMessageRouterRule> rules = new ArrayList<WxMpMessageRouterRule>();
    private final WxMpService wxMpService;
    private ExecutorService executorService;
    private WxMessageDuplicateChecker messageDuplicateChecker;
    private WxSessionManager sessionManager;
    private WxErrorExceptionHandler exceptionHandler;

    public WxMpMessageRouter(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("WxMpMessageRouter-pool-%d").build();
        this.executorService = new ThreadPoolExecutor(100, 100, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
        this.messageDuplicateChecker = WxMessageInMemoryDuplicateCheckerSingleton.getInstance();
        this.sessionManager = new StandardSessionManager();
        this.exceptionHandler = new LogExceptionHandler();
    }

    public WxMpMessageRouter(WxMpService wxMpService, ExecutorService executorService) {
        this.wxMpService = wxMpService;
        this.executorService = executorService;
        this.messageDuplicateChecker = WxMessageInMemoryDuplicateCheckerSingleton.getInstance();
        this.sessionManager = new StandardSessionManager();
        this.exceptionHandler = new LogExceptionHandler();
    }

    public void shutDownExecutorService() {
        this.executorService.shutdown();
    }

    public void shutDownExecutorService(Integer second) {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(second.intValue(), TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(second.intValue(), TimeUnit.SECONDS)) {
                    log.error("\u7ebf\u7a0b\u6c60\u672a\u5173\u95ed\uff01");
                }
            }
        }
        catch (InterruptedException ie) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setMessageDuplicateChecker(WxMessageDuplicateChecker messageDuplicateChecker) {
        this.messageDuplicateChecker = messageDuplicateChecker;
    }

    public void setSessionManager(WxSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setExceptionHandler(WxErrorExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    List<WxMpMessageRouterRule> getRules() {
        return this.rules;
    }

    public WxMpMessageRouterRule rule() {
        return new WxMpMessageRouterRule(this);
    }

    public WxMpXmlOutMessage route(WxMpXmlMessage wxMessage, Map<String, Object> context) {
        return this.route(wxMessage, context, null);
    }

    public WxMpXmlOutMessage route(String appid, WxMpXmlMessage wxMessage, Map<String, Object> context) {
        return this.route(wxMessage, context, this.wxMpService.switchoverTo(appid));
    }

    public WxMpXmlOutMessage route(WxMpXmlMessage wxMessage, Map<String, Object> context, WxMpService wxMpService) {
        if (wxMpService == null) {
            wxMpService = this.wxMpService;
        }
        WxMpService mpService = wxMpService;
        if (this.isMsgDuplicated(wxMessage)) {
            return null;
        }
        ArrayList<WxMpMessageRouterRule> matchRules = new ArrayList<WxMpMessageRouterRule>();
        for (WxMpMessageRouterRule rule : this.rules) {
            if (!rule.test(wxMessage)) continue;
            matchRules.add(rule);
            if (rule.isReEnter()) continue;
            break;
        }
        if (matchRules.isEmpty()) {
            return null;
        }
        WxMpXmlOutMessage res = null;
        ArrayList futures = new ArrayList();
        String appId = WxMpConfigStorageHolder.get();
        for (WxMpMessageRouterRule rule : matchRules) {
            if (rule.isAsync()) {
                futures.add(this.executorService.submit(() -> {
                    this.wxMpService.switchoverTo(appId);
                    rule.service(wxMessage, context, mpService, this.sessionManager, this.exceptionHandler);
                }));
                continue;
            }
            res = rule.service(wxMessage, context, mpService, this.sessionManager, this.exceptionHandler);
            log.debug("End session access: async=false, sessionId={}", (Object)wxMessage.getFromUser());
            this.sessionEndAccess(wxMessage);
        }
        if (futures.isEmpty()) {
            return res;
        }
        this.executorService.submit(() -> {
            for (Future future : futures) {
                try {
                    future.get();
                    log.debug("End session access: async=true, sessionId={}", (Object)wxMessage.getFromUser());
                    this.sessionEndAccess(wxMessage);
                }
                catch (InterruptedException e) {
                    log.error("Error happened when wait task finish", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    log.error("Error happened when wait task finish", (Throwable)e);
                }
            }
        });
        return res;
    }

    public WxMpXmlOutMessage route(WxMpXmlMessage wxMessage) {
        return this.route(wxMessage, new HashMap<String, Object>(2));
    }

    public WxMpXmlOutMessage route(String appid, WxMpXmlMessage wxMessage) {
        return this.route(appid, wxMessage, new HashMap<String, Object>(2));
    }

    private boolean isMsgDuplicated(WxMpXmlMessage wxMessage) {
        StringBuilder messageId = new StringBuilder();
        if (wxMessage.getMsgId() == null) {
            messageId.append(wxMessage.getCreateTime()).append("-").append(wxMessage.getFromUser()).append("-").append(StringUtils.trimToEmpty((String)wxMessage.getEventKey())).append("-").append(StringUtils.trimToEmpty((String)wxMessage.getEvent()));
        } else {
            messageId.append(wxMessage.getMsgId()).append("-").append(wxMessage.getCreateTime()).append("-").append(wxMessage.getFromUser());
        }
        if (StringUtils.isNotEmpty((CharSequence)wxMessage.getUserCardCode())) {
            messageId.append("-").append(wxMessage.getUserCardCode());
        }
        return this.messageDuplicateChecker.isDuplicate(messageId.toString());
    }

    private void sessionEndAccess(WxMpXmlMessage wxMessage) {
        InternalSession session = ((InternalSessionManager)this.sessionManager).findSession(wxMessage.getFromUser());
        if (session != null) {
            session.endAccess();
        }
    }

    public WxMpMessageRouter(WxMpService wxMpService, ExecutorService executorService, WxMessageDuplicateChecker messageDuplicateChecker, WxSessionManager sessionManager, WxErrorExceptionHandler exceptionHandler) {
        this.wxMpService = wxMpService;
        this.executorService = executorService;
        this.messageDuplicateChecker = messageDuplicateChecker;
        this.sessionManager = sessionManager;
        this.exceptionHandler = exceptionHandler;
    }
}

