/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.api.impl;

import cn.binarywang.wx.miniapp.config.WxMaConfig;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.enums.TicketType;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import me.chanjar.weixin.mp.bean.WxMpHostConfig;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.open.api.WxOpenConfigStorage;
import me.chanjar.weixin.open.bean.WxOpenAuthorizerAccessToken;
import me.chanjar.weixin.open.bean.WxOpenComponentAccessToken;
import me.chanjar.weixin.open.util.json.WxOpenGsonBuilder;

public class WxOpenInMemoryConfigStorage
implements WxOpenConfigStorage {
    private String componentAppId;
    private String componentAppSecret;
    private String componentToken;
    private String componentAesKey;
    private String componentVerifyTicket;
    private String componentAccessToken;
    private long componentExpiresTime;
    private String httpProxyHost;
    private int httpProxyPort;
    private String httpProxyUsername;
    private String httpProxyPassword;
    private ApacheHttpClientBuilder apacheHttpClientBuilder;
    private Map<String, Token> authorizerRefreshTokens = new ConcurrentHashMap<String, Token>();
    private Map<String, Token> authorizerAccessTokens = new ConcurrentHashMap<String, Token>();
    private Map<String, Token> jsapiTickets = new ConcurrentHashMap<String, Token>();
    private Map<String, Token> cardApiTickets = new ConcurrentHashMap<String, Token>();
    private Map<String, Lock> locks = new ConcurrentHashMap<String, Lock>();
    private Lock accessTokenLockInstance;

    @Override
    public boolean isComponentAccessTokenExpired() {
        return System.currentTimeMillis() > this.componentExpiresTime;
    }

    @Override
    public void expireComponentAccessToken() {
        this.componentExpiresTime = 0L;
    }

    @Override
    public void updateComponentAccessToken(WxOpenComponentAccessToken componentAccessToken) {
        this.updateComponentAccessToken(componentAccessToken.getComponentAccessToken(), componentAccessToken.getExpiresIn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock getComponentAccessTokenLock() {
        if (this.accessTokenLockInstance == null) {
            WxOpenInMemoryConfigStorage wxOpenInMemoryConfigStorage = this;
            synchronized (wxOpenInMemoryConfigStorage) {
                if (this.accessTokenLockInstance == null) {
                    this.accessTokenLockInstance = this.getLockByKey("componentAccessTokenLock");
                }
            }
        }
        return this.accessTokenLockInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock getLockByKey(String key) {
        Lock lock = this.locks.get(key);
        if (lock == null) {
            WxOpenInMemoryConfigStorage wxOpenInMemoryConfigStorage = this;
            synchronized (wxOpenInMemoryConfigStorage) {
                lock = this.locks.get(key);
                if (lock == null) {
                    lock = new ReentrantLock();
                    this.locks.put(key, lock);
                }
            }
        }
        return lock;
    }

    @Override
    public WxMpConfigStorage getWxMpConfigStorage(String appId) {
        return new WxOpenInnerConfigStorage(this, appId);
    }

    @Override
    public WxMaConfig getWxMaConfig(String appId) {
        return new WxOpenInnerConfigStorage(this, appId);
    }

    @Override
    public void updateComponentAccessToken(String componentAccessToken, int expiresInSeconds) {
        this.componentAccessToken = componentAccessToken;
        this.componentExpiresTime = System.currentTimeMillis() + (long)(expiresInSeconds - 200) * 1000L;
    }

    @Override
    public void setWxOpenInfo(String componentAppId, String componentAppSecret, String componentToken, String componentAesKey) {
        this.setComponentAppId(componentAppId);
        this.setComponentAppSecret(componentAppSecret);
        this.setComponentToken(componentToken);
        this.setComponentAesKey(componentAesKey);
    }

    @Override
    public boolean autoRefreshToken() {
        return true;
    }

    private String getTokenString(Map<String, Token> map, String key) {
        Token token = map.get(key);
        if (token == null || token.expiresTime != null && System.currentTimeMillis() > token.expiresTime) {
            return null;
        }
        return token.token;
    }

    private void expireToken(Map<String, Token> map, String key) {
        Token token = map.get(key);
        if (token != null) {
            token.expiresTime = 0L;
        }
    }

    private void updateToken(Map<String, Token> map, String key, String tokenString, Integer expiresInSeconds) {
        Token token = map.get(key);
        if (token == null) {
            token = new Token();
            map.put(key, token);
        }
        token.token = tokenString;
        if (expiresInSeconds != null) {
            token.expiresTime = System.currentTimeMillis() + (long)(expiresInSeconds - 200) * 1000L;
        }
    }

    @Override
    public String getAuthorizerRefreshToken(String appId) {
        return this.getTokenString(this.authorizerRefreshTokens, appId);
    }

    @Override
    public void setAuthorizerRefreshToken(String appId, String authorizerRefreshToken) {
        this.updateToken(this.authorizerRefreshTokens, appId, authorizerRefreshToken, null);
    }

    @Override
    public String getAuthorizerAccessToken(String appId) {
        return this.getTokenString(this.authorizerAccessTokens, appId);
    }

    @Override
    public boolean isAuthorizerAccessTokenExpired(String appId) {
        return this.getTokenString(this.authorizerAccessTokens, appId) == null;
    }

    @Override
    public void expireAuthorizerAccessToken(String appId) {
        this.expireToken(this.authorizerAccessTokens, appId);
    }

    @Override
    public void updateAuthorizerAccessToken(String appId, WxOpenAuthorizerAccessToken authorizerAccessToken) {
        this.updateAuthorizerAccessToken(appId, authorizerAccessToken.getAuthorizerAccessToken(), authorizerAccessToken.getExpiresIn());
    }

    @Override
    public void updateAuthorizerAccessToken(String appId, String authorizerAccessToken, int expiresInSeconds) {
        this.updateToken(this.authorizerAccessTokens, appId, authorizerAccessToken, expiresInSeconds);
    }

    @Override
    public String getJsapiTicket(String appId) {
        return this.getTokenString(this.jsapiTickets, appId);
    }

    @Override
    public boolean isJsapiTicketExpired(String appId) {
        return this.getTokenString(this.jsapiTickets, appId) == null;
    }

    @Override
    public void expireJsapiTicket(String appId) {
        this.expireToken(this.jsapiTickets, appId);
    }

    @Override
    public void updateJsapiTicket(String appId, String jsapiTicket, int expiresInSeconds) {
        this.updateToken(this.jsapiTickets, appId, jsapiTicket, expiresInSeconds);
    }

    @Override
    public String getCardApiTicket(String appId) {
        return this.getTokenString(this.cardApiTickets, appId);
    }

    @Override
    public boolean isCardApiTicketExpired(String appId) {
        return this.getTokenString(this.cardApiTickets, appId) == null;
    }

    @Override
    public void expireCardApiTicket(String appId) {
        this.expireToken(this.cardApiTickets, appId);
    }

    @Override
    public void updateCardApiTicket(String appId, String cardApiTicket, int expiresInSeconds) {
        this.updateToken(this.cardApiTickets, appId, cardApiTicket, expiresInSeconds);
    }

    @Override
    public String getComponentAppId() {
        return this.componentAppId;
    }

    @Override
    public String getComponentAppSecret() {
        return this.componentAppSecret;
    }

    @Override
    public String getComponentToken() {
        return this.componentToken;
    }

    @Override
    public String getComponentAesKey() {
        return this.componentAesKey;
    }

    @Override
    public String getComponentVerifyTicket() {
        return this.componentVerifyTicket;
    }

    @Override
    public String getComponentAccessToken() {
        return this.componentAccessToken;
    }

    public long getComponentExpiresTime() {
        return this.componentExpiresTime;
    }

    @Override
    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    @Override
    public int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    @Override
    public String getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    @Override
    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    @Override
    public ApacheHttpClientBuilder getApacheHttpClientBuilder() {
        return this.apacheHttpClientBuilder;
    }

    public Map<String, Token> getAuthorizerRefreshTokens() {
        return this.authorizerRefreshTokens;
    }

    public Map<String, Token> getAuthorizerAccessTokens() {
        return this.authorizerAccessTokens;
    }

    public Map<String, Token> getJsapiTickets() {
        return this.jsapiTickets;
    }

    public Map<String, Token> getCardApiTickets() {
        return this.cardApiTickets;
    }

    public Map<String, Lock> getLocks() {
        return this.locks;
    }

    public Lock getAccessTokenLockInstance() {
        return this.accessTokenLockInstance;
    }

    @Override
    public void setComponentAppId(String componentAppId) {
        this.componentAppId = componentAppId;
    }

    @Override
    public void setComponentAppSecret(String componentAppSecret) {
        this.componentAppSecret = componentAppSecret;
    }

    @Override
    public void setComponentToken(String componentToken) {
        this.componentToken = componentToken;
    }

    @Override
    public void setComponentAesKey(String componentAesKey) {
        this.componentAesKey = componentAesKey;
    }

    @Override
    public void setComponentVerifyTicket(String componentVerifyTicket) {
        this.componentVerifyTicket = componentVerifyTicket;
    }

    public void setComponentAccessToken(String componentAccessToken) {
        this.componentAccessToken = componentAccessToken;
    }

    public void setComponentExpiresTime(long componentExpiresTime) {
        this.componentExpiresTime = componentExpiresTime;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public void setHttpProxyPort(int httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public void setHttpProxyUsername(String httpProxyUsername) {
        this.httpProxyUsername = httpProxyUsername;
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    public void setApacheHttpClientBuilder(ApacheHttpClientBuilder apacheHttpClientBuilder) {
        this.apacheHttpClientBuilder = apacheHttpClientBuilder;
    }

    public void setAuthorizerRefreshTokens(Map<String, Token> authorizerRefreshTokens) {
        this.authorizerRefreshTokens = authorizerRefreshTokens;
    }

    public void setAuthorizerAccessTokens(Map<String, Token> authorizerAccessTokens) {
        this.authorizerAccessTokens = authorizerAccessTokens;
    }

    public void setJsapiTickets(Map<String, Token> jsapiTickets) {
        this.jsapiTickets = jsapiTickets;
    }

    public void setCardApiTickets(Map<String, Token> cardApiTickets) {
        this.cardApiTickets = cardApiTickets;
    }

    public void setLocks(Map<String, Lock> locks) {
        this.locks = locks;
    }

    public void setAccessTokenLockInstance(Lock accessTokenLockInstance) {
        this.accessTokenLockInstance = accessTokenLockInstance;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxOpenInMemoryConfigStorage)) {
            return false;
        }
        WxOpenInMemoryConfigStorage other = (WxOpenInMemoryConfigStorage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$componentAppId = this.getComponentAppId();
        String other$componentAppId = other.getComponentAppId();
        if (this$componentAppId == null ? other$componentAppId != null : !this$componentAppId.equals(other$componentAppId)) {
            return false;
        }
        String this$componentAppSecret = this.getComponentAppSecret();
        String other$componentAppSecret = other.getComponentAppSecret();
        if (this$componentAppSecret == null ? other$componentAppSecret != null : !this$componentAppSecret.equals(other$componentAppSecret)) {
            return false;
        }
        String this$componentToken = this.getComponentToken();
        String other$componentToken = other.getComponentToken();
        if (this$componentToken == null ? other$componentToken != null : !this$componentToken.equals(other$componentToken)) {
            return false;
        }
        String this$componentAesKey = this.getComponentAesKey();
        String other$componentAesKey = other.getComponentAesKey();
        if (this$componentAesKey == null ? other$componentAesKey != null : !this$componentAesKey.equals(other$componentAesKey)) {
            return false;
        }
        String this$componentVerifyTicket = this.getComponentVerifyTicket();
        String other$componentVerifyTicket = other.getComponentVerifyTicket();
        if (this$componentVerifyTicket == null ? other$componentVerifyTicket != null : !this$componentVerifyTicket.equals(other$componentVerifyTicket)) {
            return false;
        }
        String this$componentAccessToken = this.getComponentAccessToken();
        String other$componentAccessToken = other.getComponentAccessToken();
        if (this$componentAccessToken == null ? other$componentAccessToken != null : !this$componentAccessToken.equals(other$componentAccessToken)) {
            return false;
        }
        if (this.getComponentExpiresTime() != other.getComponentExpiresTime()) {
            return false;
        }
        String this$httpProxyHost = this.getHttpProxyHost();
        String other$httpProxyHost = other.getHttpProxyHost();
        if (this$httpProxyHost == null ? other$httpProxyHost != null : !this$httpProxyHost.equals(other$httpProxyHost)) {
            return false;
        }
        if (this.getHttpProxyPort() != other.getHttpProxyPort()) {
            return false;
        }
        String this$httpProxyUsername = this.getHttpProxyUsername();
        String other$httpProxyUsername = other.getHttpProxyUsername();
        if (this$httpProxyUsername == null ? other$httpProxyUsername != null : !this$httpProxyUsername.equals(other$httpProxyUsername)) {
            return false;
        }
        String this$httpProxyPassword = this.getHttpProxyPassword();
        String other$httpProxyPassword = other.getHttpProxyPassword();
        if (this$httpProxyPassword == null ? other$httpProxyPassword != null : !this$httpProxyPassword.equals(other$httpProxyPassword)) {
            return false;
        }
        ApacheHttpClientBuilder this$apacheHttpClientBuilder = this.getApacheHttpClientBuilder();
        ApacheHttpClientBuilder other$apacheHttpClientBuilder = other.getApacheHttpClientBuilder();
        if (this$apacheHttpClientBuilder == null ? other$apacheHttpClientBuilder != null : !this$apacheHttpClientBuilder.equals(other$apacheHttpClientBuilder)) {
            return false;
        }
        Map<String, Token> this$authorizerRefreshTokens = this.getAuthorizerRefreshTokens();
        Map<String, Token> other$authorizerRefreshTokens = other.getAuthorizerRefreshTokens();
        if (this$authorizerRefreshTokens == null ? other$authorizerRefreshTokens != null : !((Object)this$authorizerRefreshTokens).equals(other$authorizerRefreshTokens)) {
            return false;
        }
        Map<String, Token> this$authorizerAccessTokens = this.getAuthorizerAccessTokens();
        Map<String, Token> other$authorizerAccessTokens = other.getAuthorizerAccessTokens();
        if (this$authorizerAccessTokens == null ? other$authorizerAccessTokens != null : !((Object)this$authorizerAccessTokens).equals(other$authorizerAccessTokens)) {
            return false;
        }
        Map<String, Token> this$jsapiTickets = this.getJsapiTickets();
        Map<String, Token> other$jsapiTickets = other.getJsapiTickets();
        if (this$jsapiTickets == null ? other$jsapiTickets != null : !((Object)this$jsapiTickets).equals(other$jsapiTickets)) {
            return false;
        }
        Map<String, Token> this$cardApiTickets = this.getCardApiTickets();
        Map<String, Token> other$cardApiTickets = other.getCardApiTickets();
        if (this$cardApiTickets == null ? other$cardApiTickets != null : !((Object)this$cardApiTickets).equals(other$cardApiTickets)) {
            return false;
        }
        Map<String, Lock> this$locks = this.getLocks();
        Map<String, Lock> other$locks = other.getLocks();
        if (this$locks == null ? other$locks != null : !((Object)this$locks).equals(other$locks)) {
            return false;
        }
        Lock this$accessTokenLockInstance = this.getAccessTokenLockInstance();
        Lock other$accessTokenLockInstance = other.getAccessTokenLockInstance();
        return !(this$accessTokenLockInstance == null ? other$accessTokenLockInstance != null : !this$accessTokenLockInstance.equals(other$accessTokenLockInstance));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxOpenInMemoryConfigStorage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $componentAppId = this.getComponentAppId();
        result = result * 59 + ($componentAppId == null ? 43 : $componentAppId.hashCode());
        String $componentAppSecret = this.getComponentAppSecret();
        result = result * 59 + ($componentAppSecret == null ? 43 : $componentAppSecret.hashCode());
        String $componentToken = this.getComponentToken();
        result = result * 59 + ($componentToken == null ? 43 : $componentToken.hashCode());
        String $componentAesKey = this.getComponentAesKey();
        result = result * 59 + ($componentAesKey == null ? 43 : $componentAesKey.hashCode());
        String $componentVerifyTicket = this.getComponentVerifyTicket();
        result = result * 59 + ($componentVerifyTicket == null ? 43 : $componentVerifyTicket.hashCode());
        String $componentAccessToken = this.getComponentAccessToken();
        result = result * 59 + ($componentAccessToken == null ? 43 : $componentAccessToken.hashCode());
        long $componentExpiresTime = this.getComponentExpiresTime();
        result = result * 59 + (int)($componentExpiresTime >>> 32 ^ $componentExpiresTime);
        String $httpProxyHost = this.getHttpProxyHost();
        result = result * 59 + ($httpProxyHost == null ? 43 : $httpProxyHost.hashCode());
        result = result * 59 + this.getHttpProxyPort();
        String $httpProxyUsername = this.getHttpProxyUsername();
        result = result * 59 + ($httpProxyUsername == null ? 43 : $httpProxyUsername.hashCode());
        String $httpProxyPassword = this.getHttpProxyPassword();
        result = result * 59 + ($httpProxyPassword == null ? 43 : $httpProxyPassword.hashCode());
        ApacheHttpClientBuilder $apacheHttpClientBuilder = this.getApacheHttpClientBuilder();
        result = result * 59 + ($apacheHttpClientBuilder == null ? 43 : $apacheHttpClientBuilder.hashCode());
        Map<String, Token> $authorizerRefreshTokens = this.getAuthorizerRefreshTokens();
        result = result * 59 + ($authorizerRefreshTokens == null ? 43 : ((Object)$authorizerRefreshTokens).hashCode());
        Map<String, Token> $authorizerAccessTokens = this.getAuthorizerAccessTokens();
        result = result * 59 + ($authorizerAccessTokens == null ? 43 : ((Object)$authorizerAccessTokens).hashCode());
        Map<String, Token> $jsapiTickets = this.getJsapiTickets();
        result = result * 59 + ($jsapiTickets == null ? 43 : ((Object)$jsapiTickets).hashCode());
        Map<String, Token> $cardApiTickets = this.getCardApiTickets();
        result = result * 59 + ($cardApiTickets == null ? 43 : ((Object)$cardApiTickets).hashCode());
        Map<String, Lock> $locks = this.getLocks();
        result = result * 59 + ($locks == null ? 43 : ((Object)$locks).hashCode());
        Lock $accessTokenLockInstance = this.getAccessTokenLockInstance();
        result = result * 59 + ($accessTokenLockInstance == null ? 43 : $accessTokenLockInstance.hashCode());
        return result;
    }

    public String toString() {
        return "WxOpenInMemoryConfigStorage(componentAppId=" + this.getComponentAppId() + ", componentAppSecret=" + this.getComponentAppSecret() + ", componentToken=" + this.getComponentToken() + ", componentAesKey=" + this.getComponentAesKey() + ", componentVerifyTicket=" + this.getComponentVerifyTicket() + ", componentAccessToken=" + this.getComponentAccessToken() + ", componentExpiresTime=" + this.getComponentExpiresTime() + ", httpProxyHost=" + this.getHttpProxyHost() + ", httpProxyPort=" + this.getHttpProxyPort() + ", httpProxyUsername=" + this.getHttpProxyUsername() + ", httpProxyPassword=" + this.getHttpProxyPassword() + ", apacheHttpClientBuilder=" + this.getApacheHttpClientBuilder() + ", authorizerRefreshTokens=" + this.getAuthorizerRefreshTokens() + ", authorizerAccessTokens=" + this.getAuthorizerAccessTokens() + ", jsapiTickets=" + this.getJsapiTickets() + ", cardApiTickets=" + this.getCardApiTickets() + ", locks=" + this.getLocks() + ", accessTokenLockInstance=" + this.getAccessTokenLockInstance() + ")";
    }

    private static class WxOpenInnerConfigStorage
    implements WxMpConfigStorage,
    WxMaConfig {
        private WxOpenConfigStorage wxOpenConfigStorage;
        private String appId;
        private volatile String originalId;
        private volatile String cloudEnv;
        private final Lock accessTokenLock;
        private final Lock jsapiTicketLock;
        private final Lock cardApiTicketLock;

        private WxOpenInnerConfigStorage(WxOpenConfigStorage wxOpenConfigStorage, String appId) {
            this.wxOpenConfigStorage = wxOpenConfigStorage;
            this.appId = appId;
            this.accessTokenLock = wxOpenConfigStorage.getLockByKey(appId + ":accessTokenLock");
            this.jsapiTicketLock = wxOpenConfigStorage.getLockByKey(appId + ":jsapiTicketLock");
            this.cardApiTicketLock = wxOpenConfigStorage.getLockByKey(appId + ":cardApiTicketLock");
        }

        public String getAccessToken() {
            return this.wxOpenConfigStorage.getAuthorizerAccessToken(this.appId);
        }

        public Lock getAccessTokenLock() {
            return this.accessTokenLock;
        }

        public boolean isAccessTokenExpired() {
            return this.wxOpenConfigStorage.isAuthorizerAccessTokenExpired(this.appId);
        }

        public synchronized void updateAccessToken(WxAccessToken accessToken) {
            this.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
        }

        public synchronized void updateAccessToken(String accessToken, int expiresInSeconds) {
            this.wxOpenConfigStorage.updateAuthorizerAccessToken(this.appId, accessToken, expiresInSeconds);
        }

        public String getTicket(TicketType type) {
            switch (type) {
                case JSAPI: {
                    return this.wxOpenConfigStorage.getJsapiTicket(this.appId);
                }
                case WX_CARD: {
                    return this.wxOpenConfigStorage.getCardApiTicket(this.appId);
                }
            }
            return null;
        }

        public Lock getTicketLock(TicketType type) {
            switch (type) {
                case JSAPI: {
                    return this.jsapiTicketLock;
                }
                case WX_CARD: {
                    return this.cardApiTicketLock;
                }
            }
            return null;
        }

        public boolean isTicketExpired(TicketType type) {
            switch (type) {
                case JSAPI: {
                    return this.wxOpenConfigStorage.isJsapiTicketExpired(this.appId);
                }
                case WX_CARD: {
                    return this.wxOpenConfigStorage.isCardApiTicketExpired(this.appId);
                }
            }
            return false;
        }

        public void expireTicket(TicketType type) {
            switch (type) {
                case JSAPI: {
                    this.wxOpenConfigStorage.expireJsapiTicket(this.appId);
                    break;
                }
                case WX_CARD: {
                    this.wxOpenConfigStorage.expireCardApiTicket(this.appId);
                    break;
                }
            }
        }

        public void updateTicket(TicketType type, String ticket, int expiresInSeconds) {
            switch (type) {
                case JSAPI: {
                    this.wxOpenConfigStorage.updateJsapiTicket(this.appId, ticket, expiresInSeconds);
                    break;
                }
                case WX_CARD: {
                    this.wxOpenConfigStorage.updateCardApiTicket(this.appId, ticket, expiresInSeconds);
                    break;
                }
            }
        }

        public String getAppid() {
            return this.appId;
        }

        public String getOriginalId() {
            return this.originalId;
        }

        public void setOriginalId(String originalId) {
            this.originalId = originalId;
        }

        public String getCloudEnv() {
            return this.cloudEnv;
        }

        public void setCloudEnv(String cloudEnv) {
            this.cloudEnv = cloudEnv;
        }

        public void expireAccessToken() {
            this.wxOpenConfigStorage.expireAuthorizerAccessToken(this.appId);
        }

        public String getJsapiTicket() {
            return this.wxOpenConfigStorage.getJsapiTicket(this.appId);
        }

        public Lock getJsapiTicketLock() {
            return this.jsapiTicketLock;
        }

        public boolean isJsapiTicketExpired() {
            return this.wxOpenConfigStorage.isJsapiTicketExpired(this.appId);
        }

        public synchronized void updateJsapiTicket(String jsapiTicket, int expiresInSeconds) {
            this.wxOpenConfigStorage.updateJsapiTicket(this.appId, jsapiTicket, expiresInSeconds);
        }

        public void expireJsapiTicket() {
            this.wxOpenConfigStorage.expireJsapiTicket(this.appId);
        }

        public String getCardApiTicket() {
            return this.wxOpenConfigStorage.getCardApiTicket(this.appId);
        }

        public Lock getCardApiTicketLock() {
            return this.cardApiTicketLock;
        }

        public boolean isCardApiTicketExpired() {
            return this.wxOpenConfigStorage.isCardApiTicketExpired(this.appId);
        }

        public synchronized void updateCardApiTicket(String cardApiTicket, int expiresInSeconds) {
            this.wxOpenConfigStorage.updateCardApiTicket(this.appId, cardApiTicket, expiresInSeconds);
        }

        public void expireCardApiTicket() {
            this.wxOpenConfigStorage.expireCardApiTicket(this.appId);
        }

        public String getAppId() {
            return this.appId;
        }

        public String getSecret() {
            return null;
        }

        public String getToken() {
            return this.wxOpenConfigStorage.getComponentToken();
        }

        public String getTemplateId() {
            return null;
        }

        public long getExpiresTime() {
            return 0L;
        }

        public String getAesKey() {
            return this.wxOpenConfigStorage.getComponentAesKey();
        }

        public String getMsgDataFormat() {
            return null;
        }

        public String getOauth2redirectUri() {
            return null;
        }

        public String getHttpProxyHost() {
            return this.wxOpenConfigStorage.getHttpProxyHost();
        }

        public int getHttpProxyPort() {
            return this.wxOpenConfigStorage.getHttpProxyPort();
        }

        public String getHttpProxyUsername() {
            return this.wxOpenConfigStorage.getHttpProxyUsername();
        }

        public String getHttpProxyPassword() {
            return this.wxOpenConfigStorage.getHttpProxyPassword();
        }

        public String toString() {
            return WxOpenGsonBuilder.create().toJson((Object)this);
        }

        public File getTmpDirFile() {
            return null;
        }

        public ApacheHttpClientBuilder getApacheHttpClientBuilder() {
            return this.wxOpenConfigStorage.getApacheHttpClientBuilder();
        }

        public boolean autoRefreshToken() {
            return this.wxOpenConfigStorage.autoRefreshToken();
        }

        public WxMpHostConfig getHostConfig() {
            return null;
        }
    }

    private static class Token {
        private String token;
        private Long expiresTime;

        private Token() {
        }
    }
}

