/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.service;

import com.github.davidfantasy.mybatisplus.generatorui.common.ServiceException;
import com.github.davidfantasy.mybatisplus.generatorui.dto.ElementPosition;
import com.github.davidfantasy.mybatisplus.generatorui.dto.MapperElement;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.dom.DOMComment;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.springframework.stereotype.Component;

@Component
public class MapperXmlParser {
    private SAXReader reader = new SAXReader();
    private OutputFormat format = OutputFormat.createPrettyPrint();

    public String addElementInMapper(String mapperPath, MapperElement ... elements) throws IOException, DocumentException {
        File mapperFile = new File(mapperPath);
        if (!mapperFile.exists()) {
            throw new ServiceException("XML\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + mapperPath);
        }
        Document doc = this.reader.read((InputStream)new FileInputStream(mapperFile));
        List mapperNodes = doc.getRootElement().content();
        ArrayList newNodes = Lists.newArrayList();
        for (Node node : mapperNodes) {
            if (node instanceof Element) {
                boolean equals = false;
                Element oldEle = (Element)node;
                for (MapperElement newEle : elements) {
                    if (Strings.isNullOrEmpty((String)newEle.getId()) || !newEle.getId().equals(oldEle.attributeValue("id"))) continue;
                    equals = true;
                    newEle.setExisted(true);
                }
                if (equals) continue;
                newNodes.add(node);
                continue;
            }
            newNodes.add(node);
        }
        for (MapperElement ele : elements) {
            System.out.println(ele.getContent().trim());
            Element newEle = DocumentHelper.parseText((String)ele.getContent().trim()).getRootElement();
            if (ele.getLocation().equals((Object)ElementPosition.FIRST)) {
                newNodes.add(0, newEle);
                if (ele.isExisted()) continue;
                newNodes.add(0, new DOMComment(ele.getComment()));
                continue;
            }
            if (!ele.isExisted()) {
                newNodes.add(new DOMComment(ele.getComment()));
            }
            newNodes.add(newEle);
        }
        doc.getRootElement().setContent((List)newNodes);
        XMLWriter writer = new XMLWriter((Writer)new FileWriter(mapperFile), this.format);
        writer.write(doc);
        writer.flush();
        return doc.getRootElement().attributeValue("namespace");
    }

    private Element getElementById(Document doc, String id) {
        List elements = doc.getRootElement().elements();
        for (Element ele : elements) {
            if (!id.equals(ele.attributeValue("id"))) continue;
            return ele;
        }
        return null;
    }
}

