/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.support.core;

import com.github.houbb.chars.scan.api.CharsScanContext;
import com.github.houbb.chars.scan.api.CharsScanMatchItem;
import com.github.houbb.chars.scan.api.ICharsCore;
import com.github.houbb.chars.scan.api.ICharsScanFactory;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.util.List;

public abstract class AbstractCharsCore
implements ICharsCore {
    public abstract List<CharsScanMatchItem> scan(String var1, CharsScanContext var2, char[] var3);

    public abstract String replace(List<CharsScanMatchItem> var1, String var2, CharsScanContext var3, char[] var4);

    @Override
    public String scanAndReplace(String originalString, CharsScanContext context) {
        ICharsScanFactory charScanFactory = context.getCharScanFactory();
        List<String> charsScanTypeList = charScanFactory.scanTypeList();
        if (StringUtil.isEmpty((String)originalString) || CollectionUtil.isEmpty(charsScanTypeList)) {
            return originalString;
        }
        char[] oldChars = originalString.toCharArray();
        List<CharsScanMatchItem> charsScanMatchItemList = this.scan(originalString, context, oldChars);
        if (CollectionUtil.isEmpty(charsScanMatchItemList)) {
            return originalString;
        }
        String result = this.replace(charsScanMatchItemList, originalString, context, oldChars);
        return result;
    }
}

