/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.support.scan;

import com.github.houbb.chars.scan.api.CharsScanContext;
import com.github.houbb.chars.scan.constant.CharsScanTypeEnum;
import com.github.houbb.chars.scan.support.scan.AbstractConditionCharScan;
import com.github.houbb.chars.scan.util.InnerCharUtil;
import com.github.houbb.heaven.util.lang.CharUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import java.util.List;

public class GPSConditionCharScan
extends AbstractConditionCharScan {
    @Override
    protected boolean isCharMatchCondition(int i, char c, char[] chars) {
        return CharUtil.isNumber((char)c) || '.' == c;
    }

    @Override
    protected boolean isStringMatchCondition(int i, char c, char[] chars, CharsScanContext context) {
        int bufferLen = super.getBuffer().length();
        if (bufferLen < 8 || bufferLen > 10) {
            return false;
        }
        String string = super.getBuffer().toString();
        List stringList = StringUtil.splitToList((String)string, (char)'.');
        if (stringList.size() != 2) {
            return false;
        }
        int firstNum = InnerCharUtil.parseInt((String)stringList.get(0));
        return firstNum >= 0 && firstNum <= 180;
    }

    @Override
    public String getScanType() {
        return CharsScanTypeEnum.GPS.getScanType();
    }

    @Override
    public int getPriority() {
        return CharsScanTypeEnum.GPS.getPriority();
    }
}

