/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.trie.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.trie.api.ICharIter;
import com.github.houbb.trie.impl.AbstractTrieTree;
import com.github.houbb.trie.impl.TrieTreeNodeItem;

@ThreadSafe
public class TrieTreeNode
extends AbstractTrieTree {
    private TrieTreeNodeItem root = new TrieTreeNodeItem();

    @Override
    protected void doInsert(ICharIter charIter) {
        TrieTreeNodeItem tempNode = this.root;
        int len = charIter.len();
        if (len <= 0) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            char c = charIter.charAt(i);
            TrieTreeNodeItem subNode = tempNode.getSubNode(c);
            if (subNode == null) {
                subNode = new TrieTreeNodeItem();
                tempNode.addSubNode(c, subNode);
            }
            tempNode = subNode;
        }
        tempNode.setEnd(true);
    }

    @Override
    protected boolean doSearch(ICharIter charIter) {
        TrieTreeNodeItem nowNode = this.root;
        int len = charIter.len();
        for (int i = 0; i < len; ++i) {
            if (!ObjectUtil.isNull((Object)(nowNode = nowNode.getSubNode(charIter.charAt(i))))) continue;
            return false;
        }
        return nowNode.isEnd();
    }

    @Override
    protected boolean doStartsWith(ICharIter charIter) {
        TrieTreeNodeItem nowNode = this.root;
        int len = charIter.len();
        for (int i = 0; i < len; ++i) {
            if (!ObjectUtil.isNull((Object)(nowNode = nowNode.getSubNode(charIter.charAt(i))))) continue;
            return false;
        }
        return true;
    }
}

