/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.wxpay.enums.v3;

import com.ijpay.wxpay.enums.WxDomainEnum;
import com.ijpay.wxpay.enums.v3.OtherApiEnum;

public enum CertAlgorithmTypeEnum {
    SM2("SM2", "\u56fd\u5bc6\u7b97\u6cd5\u7684\u5e73\u53f0\u8bc1\u4e66"),
    RSA("RSA", "RSA\u7b97\u6cd5\u5e73\u53f0\u8bc1\u4e66"),
    ALL("ALL", "\u6240\u6709\u7c7b\u578b\u7684\u5e73\u53f0\u8bc1\u4e66"),
    NONE("NONE", "\u9ed8\u8ba4RSA\u7b97\u6cd5\u7684\u5e73\u53f0\u8bc1\u4e66");

    private final String code;
    private final String name;

    private CertAlgorithmTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static String getCertUrl(WxDomainEnum domainEnum, CertAlgorithmTypeEnum typeEnum) {
        return domainEnum.getDomain().concat(CertAlgorithmTypeEnum.getCertSuffixUrl(typeEnum));
    }

    public static String getCertSuffixUrl(String code) {
        for (CertAlgorithmTypeEnum value : CertAlgorithmTypeEnum.values()) {
            if (!value.getCode().equals(code) || value == NONE) continue;
            return CertAlgorithmTypeEnum.getCertSuffixUrl(value);
        }
        return OtherApiEnum.GET_CERTIFICATES.getUrl();
    }

    public static String getCertSuffixUrl(CertAlgorithmTypeEnum typeEnum) {
        if (typeEnum != NONE) {
            return String.format(OtherApiEnum.GET_CERTIFICATES_BY_ALGORITHM_TYPE.getUrl(), typeEnum.getCode());
        }
        return OtherApiEnum.GET_CERTIFICATES.getUrl();
    }
}

