/*
 * Decompiled with CFR 0.152.
 */
package com.github.keran213539.commonOkHttp;

import com.github.keran213539.commonOkHttp.UploadByteFile;
import com.github.keran213539.commonOkHttp.UploadFile;
import com.github.keran213539.commonOkHttp.UploadFileBase;
import com.github.keran213539.commonOkHttp.callback.IAsyncCallback;
import com.github.keran213539.commonOkHttp.callback.IAsyncCallback4Download;
import com.github.keran213539.commonOkHttp.callback.IAsyncCallback4Response;
import com.github.keran213539.commonOkHttp.utils.HttpsUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

public final class CommonOkHttpClient {
    private OkHttpClient okHttpClient;

    CommonOkHttpClient(long readTimeout, long writeTimeout, long connectTimeout, HttpsUtils.SSLParams sslParams) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.readTimeout(readTimeout, TimeUnit.MILLISECONDS);
        builder.writeTimeout(writeTimeout, TimeUnit.MILLISECONDS);
        builder.connectTimeout(connectTimeout, TimeUnit.MILLISECONDS);
        if (sslParams != null) {
            builder.sslSocketFactory(sslParams.sSLSocketFactory, sslParams.trustManager);
            if (sslParams.hostnameVerifier != null) {
                builder.hostnameVerifier(sslParams.hostnameVerifier);
            }
        }
        this.okHttpClient = builder.build();
    }

    public String get(String url, IAsyncCallback callback) {
        Request request = new Request.Builder().get().url(url).build();
        return (String)this.sendRequest(request, false, callback, null);
    }

    public Response get(String url, Map<String, String> headerExt, IAsyncCallback4Response callback) {
        Request.Builder reqBuilder = new Request.Builder().get().url(url);
        if (headerExt != null && headerExt.size() > 0) {
            headerExt.forEach((key, value) -> reqBuilder.addHeader(key, value));
        }
        Request request = reqBuilder.build();
        return (Response)this.sendRequest(request, true, null, callback);
    }

    public String post(String url, IAsyncCallback callback) {
        return (String)this.doPost(url, null, null, callback, null, false, null);
    }

    public String post(String url, String jsonStr, IAsyncCallback callback) {
        return (String)this.doPost(url, null, jsonStr, callback, null, false, null);
    }

    public String post(String url, IAsyncCallback callback, String xmlStr) {
        return (String)this.doPost(url, null, xmlStr, "application/xml", callback, null, false, null);
    }

    public Response post(String url, String jsonStr, Map<String, String> headerExt, IAsyncCallback4Response callback) {
        return (Response)this.doPost(url, null, jsonStr, null, callback, true, headerExt);
    }

    public String post(String url, Map<String, String> prarm, IAsyncCallback callback) {
        return (String)this.doPost(url, prarm, null, callback, null, false, null);
    }

    public <T extends UploadFileBase> String post(String url, Map<String, String> prarm, List<T> files, IAsyncCallback callback) {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder.setType(MultipartBody.FORM);
        if (prarm != null) {
            prarm.forEach((k, v) -> builder.addFormDataPart(k, v));
        }
        files.stream().forEach(file -> {
            if (file instanceof UploadFile) {
                UploadFile fileTmp = (UploadFile)file;
                builder.addFormDataPart(file.getPrarmName(), fileTmp.getFile().getName(), RequestBody.create((MediaType)MediaType.parse((String)fileTmp.getMediaType()), (File)fileTmp.getFile()));
            } else if (file instanceof UploadByteFile) {
                UploadByteFile fileTmp = (UploadByteFile)file;
                builder.addFormDataPart(file.getPrarmName(), fileTmp.getFileName(), RequestBody.create((MediaType)MediaType.parse((String)fileTmp.getMediaType()), (byte[])fileTmp.getFileBytes()));
            }
        });
        MultipartBody uploadBody = builder.build();
        Request request = new Request.Builder().post((RequestBody)uploadBody).url(url).build();
        return (String)this.sendRequest(request, false, callback, null);
    }

    private Object doPost(String url, Map<String, String> prarm, String jsonStr, IAsyncCallback callback, IAsyncCallback4Response callback4Response, boolean isNeedResponse, Map<String, String> headerExt) {
        return this.doPost(url, prarm, jsonStr, "application/json", callback, callback4Response, isNeedResponse, headerExt);
    }

    private Object doPost(String url, Map<String, String> prarm, String postStr, String dataMediaType, IAsyncCallback callback, IAsyncCallback4Response callback4Response, boolean isNeedResponse, Map<String, String> headerExt) {
        RequestBody body = Util.EMPTY_REQUEST;
        if (StringUtils.isNotBlank((String)postStr)) {
            body = RequestBody.create((MediaType)MediaType.parse((String)(dataMediaType + "; charset=utf-8")), (String)postStr);
        } else if (!CollectionUtils.isEmpty(prarm)) {
            FormBody.Builder builder = new FormBody.Builder();
            prarm.forEach((k, v) -> builder.add(k, v));
            body = builder.build();
        }
        Request.Builder reqBuilder = new Request.Builder().post(body).url(url);
        if (headerExt != null && headerExt.size() > 0) {
            headerExt.forEach((key, value) -> reqBuilder.addHeader(key, value));
        }
        Request request = reqBuilder.build();
        return this.sendRequest(request, isNeedResponse, callback, callback4Response);
    }

    private Object sendRequest(Request request, final boolean isNeedResponse, final IAsyncCallback callback, final IAsyncCallback4Response callback4Response) {
        if (callback == null && callback4Response == null) {
            try {
                Response response = this.okHttpClient.newCall(request).execute();
                if (isNeedResponse) {
                    return response;
                }
                return response.body().string();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.okHttpClient.newCall(request).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    if (isNeedResponse) {
                        callback4Response.doCallback(null);
                    } else {
                        callback.doCallback(null);
                    }
                }

                public void onResponse(Call call, Response response) {
                    try {
                        if (isNeedResponse) {
                            callback4Response.doCallback(response);
                        } else {
                            callback.doCallback(response.body().string());
                        }
                    }
                    catch (IOException e) {
                        callback.doCallback(null);
                    }
                }
            });
        }
        return null;
    }

    private Object download(String url, final boolean isNeedResponse, Map<String, String> headerExt, final IAsyncCallback4Download callback, final IAsyncCallback4Response callback4Response) {
        Request.Builder reqBuilder = new Request.Builder().get().url(url);
        if (headerExt != null && headerExt.size() > 0) {
            headerExt.forEach((key, value) -> reqBuilder.addHeader(key, value));
        }
        Request request = reqBuilder.build();
        if (callback == null && callback4Response == null) {
            try {
                Response response = this.okHttpClient.newCall(request).execute();
                if (isNeedResponse) {
                    return response;
                }
                return response.body().bytes();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.okHttpClient.newCall(request).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    if (isNeedResponse) {
                        callback4Response.doCallback(null);
                    } else {
                        callback.doCallback(null);
                    }
                }

                public void onResponse(Call call, Response response) {
                    try {
                        if (isNeedResponse) {
                            callback4Response.doCallback(response);
                        } else {
                            callback.doCallback(response.body().bytes());
                        }
                    }
                    catch (IOException e) {
                        callback.doCallback(null);
                    }
                }
            });
        }
        return null;
    }

    public byte[] download(String url, Map<String, String> headerExt, IAsyncCallback4Download callback) {
        return (byte[])this.download(url, false, headerExt, callback, null);
    }

    public Response download(Map<String, String> headerExt, IAsyncCallback4Response callback, String url) {
        return (Response)this.download(url, true, headerExt, null, callback);
    }

    public byte[] download(String url, IAsyncCallback4Download callback) {
        return (byte[])this.download(url, false, null, callback, null);
    }

    public Response download(IAsyncCallback4Response callback, String url) {
        return (Response)this.download(url, true, null, null, callback);
    }
}

