/*
 * Decompiled with CFR 0.152.
 */
package com.quaint.poster.core.decorators;

import com.quaint.poster.core.abst.AbstractPosterDecorator;
import com.quaint.poster.core.abst.Poster;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class BackgroundDecorator
extends AbstractPosterDecorator {
    private BufferedImage bgImage;

    public BackgroundDecorator() {
        super(null);
    }

    public BackgroundDecorator(Poster poster, int positionX, int positionY, int width, int height, BufferedImage bgImage) {
        super(poster, positionX, positionY, width, height);
        this.bgImage = bgImage;
    }

    @Override
    public BufferedImage draw(BufferedImage image) {
        return this.drawBackground(this.bgImage);
    }

    private BufferedImage drawBackground(BufferedImage image) {
        if (this.width == 0 || this.height == 0) {
            return image;
        }
        if (this.width != image.getWidth() || this.height != image.getHeight()) {
            BufferedImage newImage = new BufferedImage(this.width, this.height, 4);
            Graphics2D g = newImage.createGraphics();
            g.drawImage(image, 0, 0, this.width, this.height, null);
            g.dispose();
            return newImage;
        }
        return image;
    }

    public static BackgroundDecoratorBuilder builder() {
        return new BackgroundDecoratorBuilder();
    }

    public BackgroundDecoratorBuilder toBuilder() {
        return new BackgroundDecoratorBuilder().poster(this.poster).positionX(this.positionX).positionY(this.positionY).width(this.width).height(this.height).bgImage(this.bgImage);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BackgroundDecorator)) {
            return false;
        }
        BackgroundDecorator other = (BackgroundDecorator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BufferedImage this$bgImage = this.getBgImage();
        BufferedImage other$bgImage = other.getBgImage();
        return !(this$bgImage == null ? other$bgImage != null : !this$bgImage.equals(other$bgImage));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BackgroundDecorator;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        BufferedImage $bgImage = this.getBgImage();
        result = result * 59 + ($bgImage == null ? 43 : $bgImage.hashCode());
        return result;
    }

    public BufferedImage getBgImage() {
        return this.bgImage;
    }

    public void setBgImage(BufferedImage bgImage) {
        this.bgImage = bgImage;
    }

    @Override
    public String toString() {
        return "BackgroundDecorator(bgImage=" + this.getBgImage() + ")";
    }

    public static class BackgroundDecoratorBuilder {
        private Poster poster;
        private int positionX;
        private int positionY;
        private int width;
        private int height;
        private BufferedImage bgImage;

        BackgroundDecoratorBuilder() {
        }

        public BackgroundDecoratorBuilder poster(Poster poster) {
            this.poster = poster;
            return this;
        }

        public BackgroundDecoratorBuilder positionX(int positionX) {
            this.positionX = positionX;
            return this;
        }

        public BackgroundDecoratorBuilder positionY(int positionY) {
            this.positionY = positionY;
            return this;
        }

        public BackgroundDecoratorBuilder width(int width) {
            this.width = width;
            return this;
        }

        public BackgroundDecoratorBuilder height(int height) {
            this.height = height;
            return this;
        }

        public BackgroundDecoratorBuilder bgImage(BufferedImage bgImage) {
            this.bgImage = bgImage;
            return this;
        }

        public BackgroundDecorator build() {
            return new BackgroundDecorator(this.poster, this.positionX, this.positionY, this.width, this.height, this.bgImage);
        }

        public String toString() {
            return "BackgroundDecorator.BackgroundDecoratorBuilder(poster=" + this.poster + ", positionX=" + this.positionX + ", positionY=" + this.positionY + ", width=" + this.width + ", height=" + this.height + ", bgImage=" + this.bgImage + ")";
        }
    }
}

