/*
 * Decompiled with CFR 0.152.
 */
package com.quaint.poster.core.impl;

import com.quaint.poster.annotation.PosterBackground;
import com.quaint.poster.annotation.PosterFontCss;
import com.quaint.poster.annotation.PosterImageCss;
import com.quaint.poster.core.abst.Poster;
import com.quaint.poster.core.decorators.BackgroundDecorator;
import com.quaint.poster.core.decorators.ImageDecorator;
import com.quaint.poster.core.decorators.TextDecorator;
import com.quaint.poster.core.impl.PosterTemplate;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;

public class PosterDefaultImpl<E>
implements PosterTemplate<E> {
    @Override
    public Poster annotationDrawPoster(E content) throws IllegalAccessException {
        Field[] fields = content.getClass().getDeclaredFields();
        if (fields.length > 0 && fields[0].getAnnotation(PosterBackground.class) != null) {
            PosterBackground ann = fields[0].getAnnotation(PosterBackground.class);
            fields[0].setAccessible(true);
            Object o = fields[0].get(content);
            if (!(o instanceof BufferedImage)) {
                throw new RuntimeException("\u80cc\u666f\u6ce8\u89e3\u6807\u8bb0\u7684\u7c7b\u578b\u9700\u8981\u4e3aBufferedImage, \u5e76\u4e14\u4e0d\u53ef\u4e3a\u7a7a.");
            }
            BufferedImage bg = (BufferedImage)o;
            Poster finalDraw = new BackgroundDecorator().toBuilder().bgImage(bg).width(ann.width()).height(ann.height()).build();
            for (Field field : fields) {
                field.setAccessible(true);
                Object value = field.get(content);
                if (value instanceof String) {
                    String str = (String)value;
                    PosterFontCss posterFontCss = field.getAnnotation(PosterFontCss.class);
                    finalDraw = this.drawTextImpl(finalDraw, str, posterFontCss);
                    continue;
                }
                if (!(value instanceof BufferedImage)) continue;
                BufferedImage image = (BufferedImage)value;
                PosterImageCss posterImageCss = field.getAnnotation(PosterImageCss.class);
                finalDraw = this.drawImageImpl(finalDraw, image, posterImageCss);
            }
            return finalDraw;
        }
        throw new RuntimeException("\u7ed8\u5236\u5b57\u6bb5\u4e3a\u7a7a,\u6216\u8005\u7b2c\u4e00\u4e2a\u5c5e\u6027\u4e0d\u662f\u80cc\u666f,\u5e76\u4e14\u6ca1\u6709\u6807\u8bb0\u80cc\u666f\u6ce8\u89e3");
    }

    protected Poster drawTextImpl(Poster base, String text, PosterFontCss ann) {
        if (ann == null) {
            return base;
        }
        return new TextDecorator(base).toBuilder().positionX(ann.position()[0]).positionY(ann.position()[1]).fontSize(ann.size()).canNewLine(ann.canNewLine()[0] == 1).width(ann.canNewLine()[1]).newLineLimit(ann.canNewLine()[2]).color(new Color(ann.color()[0], ann.color()[1], ann.color()[2])).content(text).build();
    }

    protected Poster drawImageImpl(Poster base, BufferedImage image, PosterImageCss ann) {
        if (ann == null) {
            return base;
        }
        return new ImageDecorator(base).toBuilder().positionX(ann.position()[0]).positionY(ann.position()[1]).width(ann.width()).height(ann.height()).circle(ann.circle()).image(image).build();
    }
}

