/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.enums;

import com.xkzhangsan.time.utils.CollectionUtil;
import com.xkzhangsan.time.utils.CommonCache;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public enum ChineseDateDigitEnum {
    ZERO("\u3007"),
    ONE("\u4e00"),
    TWO("\u4e8c"),
    THREE("\u4e09"),
    FOUR("\u56db"),
    FIVE("\u4e94"),
    SIX("\u516d"),
    SEVEN("\u4e03"),
    EIGHT("\u516b"),
    NINE("\u4e5d"),
    TEN("\u5341"),
    ELEVEN("\u5341\u4e00"),
    TWELVE("\u5341\u4e8c"),
    THIRTEEN("\u5341\u4e09"),
    FOURTEEN("\u5341\u56db"),
    FIFTEEN("\u5341\u4e94"),
    SIXTEEN("\u5341\u516d"),
    SEVENTEEN("\u5341\u4e03"),
    EIGHTEEN("\u5341\u516b"),
    NINETEEN("\u5341\u4e5d"),
    TWENTY("\u4e8c\u5341"),
    TWENTYONE("\u4e8c\u5341\u4e00"),
    TWENTYTWO("\u4e8c\u5341\u4e8c"),
    TWENTYTHREE("\u4e8c\u5341\u4e09"),
    TWENTYFOUR("\u4e8c\u5341\u56db"),
    TWENTYFIVE("\u4e8c\u5341\u4e94"),
    TWENTYSIX("\u4e8c\u5341\u516d"),
    TWENTYSEVEN("\u4e8c\u5341\u4e03"),
    TWENTYEIGHT("\u4e8c\u5341\u516b"),
    TWENTYNINE("\u4e8c\u5341\u4e5d"),
    THIRTY("\u4e09\u5341"),
    THIRTYONE("\u4e09\u5341\u4e00");

    public static final ChineseDateDigitEnum[] ENUMS;
    public static final String CHINESE_DATE_DIGIT_MAP = "CHINESE_DATE_DIGIT_MAP";
    private String chineseDigit;

    private ChineseDateDigitEnum(String chineseDigit) {
        this.chineseDigit = chineseDigit;
    }

    public String getChineseDigit() {
        return this.chineseDigit;
    }

    public static Integer getIndexUseCache(String chineseDigit) {
        Map chineseDateDigitMap = new HashMap(32);
        chineseDateDigitMap = (Map)CommonCache.get(CHINESE_DATE_DIGIT_MAP);
        if (CollectionUtil.isNotEmpty(chineseDateDigitMap)) {
            return (Integer)chineseDateDigitMap.get(chineseDigit);
        }
        Supplier<Object> supplier = new Supplier<Object>(){

            @Override
            public Object get() {
                HashMap<String, Integer> dateDigitMap = new HashMap<String, Integer>();
                for (ChineseDateDigitEnum chineseDateDigitEnum : ENUMS) {
                    dateDigitMap.put(chineseDateDigitEnum.getChineseDigit(), chineseDateDigitEnum.ordinal());
                }
                return dateDigitMap;
            }
        };
        return (Integer)((Map)CommonCache.get(CHINESE_DATE_DIGIT_MAP, supplier)).get(chineseDigit);
    }

    static {
        ENUMS = ChineseDateDigitEnum.values();
    }
}

