/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.BaseQueryResultsSource;
import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreCallbacks;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityTranslator;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.IndexTranslator;
import com.google.appengine.api.datastore.Projection;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;

class QueryResultsSourceV3
extends BaseQueryResultsSource<DatastorePb.QueryResult, DatastorePb.NextRequest, DatastorePb.QueryResult> {
    private final ApiProxy.ApiConfig apiConfig;

    QueryResultsSourceV3(DatastoreCallbacks callbacks, FetchOptions fetchOptions, Transaction txn, Query query, Future<DatastorePb.QueryResult> initialQueryResultFuture, ApiProxy.ApiConfig apiConfig) {
        super(callbacks, fetchOptions, txn, query, initialQueryResultFuture);
        this.apiConfig = apiConfig;
    }

    @Override
    public DatastorePb.NextRequest buildNextCallPrototype(DatastorePb.QueryResult initialResult) {
        DatastorePb.NextRequest req = new DatastorePb.NextRequest();
        req.setCursor(initialResult.getCursor());
        if (initialResult.hasCompiledCursor()) {
            req.setCompile(true);
        }
        req.freeze();
        return req;
    }

    @Override
    public Future<DatastorePb.QueryResult> makeNextCall(DatastorePb.NextRequest reqPrototype, BaseQueryResultsSource.WrappedQueryResult unused, Integer fetchCount, Integer offsetOrNull) {
        DatastorePb.NextRequest req = (DatastorePb.NextRequest)reqPrototype.clone();
        if (fetchCount != null) {
            req.setCount(fetchCount);
        }
        if (offsetOrNull != null) {
            req.setOffset(offsetOrNull);
        }
        return DatastoreApiHelper.makeAsyncCall(this.apiConfig, DatastorePb.DatastoreService_3.Method.Next, req, new DatastorePb.QueryResult());
    }

    @Override
    public BaseQueryResultsSource.WrappedQueryResult wrapResult(DatastorePb.QueryResult result) {
        return new WrappedQueryResultV3(result);
    }

    @Override
    public BaseQueryResultsSource.WrappedQueryResult wrapInitialResult(DatastorePb.QueryResult initialResult) {
        return new WrappedQueryResultV3(initialResult);
    }

    private static class WrappedQueryResultV3
    implements BaseQueryResultsSource.WrappedQueryResult {
        private final DatastorePb.QueryResult res;

        WrappedQueryResultV3(DatastorePb.QueryResult res) {
            this.res = res;
        }

        @Override
        public List<Entity> getEntities(Collection<Projection> projections) {
            ArrayList<Entity> entities = Lists.newArrayListWithCapacity(this.res.resultSize());
            if (projections.isEmpty()) {
                for (OnestoreEntity.EntityProto entityProto : this.res.results()) {
                    entities.add(EntityTranslator.createFromPb(entityProto));
                }
            } else {
                for (OnestoreEntity.EntityProto entityProto : this.res.results()) {
                    entities.add(EntityTranslator.createFromPb(entityProto, projections));
                }
            }
            return entities;
        }

        @Override
        public List<Cursor> getResultCursors() {
            ArrayList<Cursor> cursors = Lists.newArrayListWithCapacity(this.res.resultSize());
            for (DatastorePb.CompiledCursor compiledCursor : this.res.resultCompiledCursors()) {
                cursors.add(new Cursor(compiledCursor.toByteString()));
            }
            cursors.addAll(Collections.nCopies(this.res.resultSize() - cursors.size(), null));
            return cursors;
        }

        @Override
        public int numSkippedResults() {
            return this.res.getSkippedResults();
        }

        @Override
        public Cursor getSkippedResultsCursor() {
            return this.res.hasSkippedResultsCompiledCursor() ? new Cursor(this.res.getSkippedResultsCompiledCursor().toByteString()) : null;
        }

        @Override
        public boolean hasMoreResults() {
            return this.res.isMoreResults();
        }

        @Override
        public Cursor getEndCursor() {
            return this.res.hasCompiledCursor() ? new Cursor(this.res.getCompiledCursor().toByteString()) : null;
        }

        @Override
        public List<Index> getIndexInfo(Collection<Index> monitoredIndexBuffer) {
            ArrayList<Index> indexList = Lists.newArrayListWithCapacity(this.res.indexSize());
            for (OnestoreEntity.CompositeIndex indexProtobuf : this.res.indexs()) {
                Index index = IndexTranslator.convertFromPb(indexProtobuf);
                indexList.add(index);
                if (!indexProtobuf.isOnlyUseIfRequired()) continue;
                monitoredIndexBuffer.add(index);
            }
            return indexList;
        }

        @Override
        public boolean madeProgress(BaseQueryResultsSource.WrappedQueryResult previousResult) {
            return true;
        }
    }
}

