package com.omni.ads.anno;

import org.springframework.stereotype.Component;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

@Component
public class RangeValidator implements ConstraintValidator<AdRange, Integer> {

    // 传入进来的枚举值
    private int[] values;

    @Override
    public void initialize(AdRange constraintAnnotation) {
        this.values = constraintAnnotation.values();
    }

    @Override
    public boolean isValid(Integer value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (values == null || values.length == 0) {
            return true;
        }
        for (int v : values) {
            if (v == value) {
                return true;
            }
        }
        return false;
    }
}
