package com.omni.ads.api;

import com.google.gson.reflect.TypeToken;
import com.omni.ads.baseconfig.*;
import com.omni.ads.model.adsagency.*;
import com.omni.ads.model.adsauth.AdsBaseForm;
import com.omni.ads.utils.JsonToMapUtils;
import com.omni.ads.utils.ThreadLocalUtil;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdsAgencyApi {
    private ApiClient apiClient;

    public AdsAgencyApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AdsAgencyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * 查询所有子客户和次级代理商
     *
     * @return AdsQueryAllCustomerInfoResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsQueryAllCustomerInfoResponse queryAllCustomer(CustomerListReq data) throws ApiException {
        ApiResponse<AdsQueryAllCustomerInfoResponse> resp = queryAllCustomerWithHttpInfo(data);
        return resp.getData();
    }

    /**
     * 查询所有子客户和次级代理商
     *
     * @return ApiResponse&lt;AdsQueryAllCustomerInfoResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsQueryAllCustomerInfoResponse> queryAllCustomerWithHttpInfo(CustomerListReq data)
            throws ApiException {
        com.squareup.okhttp.Call call = queryAllCustomerValidateBeforeCall( data,null, null);
        Type localVarReturnType = new TypeToken<AdsQueryAllCustomerInfoResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryAllCustomerValidateBeforeCall(
            CustomerListReq data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                queryAllCustomerAddCall( data,progressListener, progressRequestListener);
        return call;
    }


    /**
     * 查询所有子客户和次级代理商
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryAllCustomerAddCall(
            CustomerListReq data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = null;
        // create path and map variables
        String localVarPath = "/v2/communal/agency/customer/list";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept","*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type","application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding","gzip,deflate,br");
        localVarHeaderParams.put("Connection","keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }


    /**
     * 查询广告主对应的菜单、数据权限信息
     *
     * @return AdsQueryMenuResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsQueryMenuResponse queryAdMenu(AdsBaseForm data) throws ApiException {
        ApiResponse<AdsQueryMenuResponse> resp = queryAdMenuWithHttpInfo(data);
        return resp.getData();
    }

    /**
     * 查询广告主对应的菜单、数据权限信息
     *
     * @return ApiResponse&lt;AdsQueryMenuResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsQueryMenuResponse> queryAdMenuWithHttpInfo(AdsBaseForm data)
            throws ApiException {
        com.squareup.okhttp.Call call = queryAdMenuValidateBeforeCall( data,null, null);
        Type localVarReturnType = new TypeToken<AdsQueryMenuResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryAdMenuValidateBeforeCall(
            AdsBaseForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                queryAdMenuAddCall( data,progressListener, progressRequestListener);
        return call;
    }


    /**
     * 查询广告主对应的菜单、数据权限信息
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryAdMenuAddCall(
            AdsBaseForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = data;
        // create path and map variables
        String localVarPath = "/v2/communal/auth/query";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept","*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type","application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization",ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding","gzip,deflate,br");
        localVarHeaderParams.put("Connection","keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 查询账务流水
     *
     * @return AdsQueryBillsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsQueryBillsResponse queryBills(AdsAccBillHisForm data, Integer page, Integer pageCount, Integer loginType) throws ApiException {
        ApiResponse<AdsQueryBillsResponse> resp = queryBillsWithHttpInfo(data,page,pageCount,loginType);
        return resp.getData();
    }

    /**
     * 查询账务流水
     *
     * @return ApiResponse&lt;AdsQueryBillsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsQueryBillsResponse> queryBillsWithHttpInfo(AdsAccBillHisForm data,Integer page,Integer pageCount,Integer loginType)
            throws ApiException {
        com.squareup.okhttp.Call call = queryBillsValidateBeforeCall( data,page,pageCount,loginType,null, null);
        Type localVarReturnType = new TypeToken<AdsQueryBillsResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryBillsValidateBeforeCall(
            AdsAccBillHisForm data,
            Integer page,
            Integer pageCount,
            Integer loginType,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                queryBillsAddCall( data,page,pageCount,loginType,progressListener, progressRequestListener);
        return call;
    }


    /**
     * 查询账务流水
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryBillsAddCall(
            AdsAccBillHisForm data,
            Integer page,
            Integer pageCount,
            Integer loginType,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = null;
        // create path and map variables
        String localVarPath = "/v2/communal/finance/billHis";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        localVarFormParams.put("page",page);
        localVarFormParams.put("pageCount",pageCount);
        localVarFormParams.put("loginType",loginType);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept","*/*");
        localVarHeaderParams.put("Content-Type","application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization",ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding","gzip,deflate,br");
        localVarHeaderParams.put("Connection","keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }


    /**
     * 查询子账户余额
     *
     * @return AdsQueryBalanceResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsQueryBalanceResponse queryOwnerBalance() throws ApiException {
        ApiResponse<AdsQueryBalanceResponse> resp = queryOwnerBalanceHttpInfo();
        return resp.getData();
    }

    /**
     * 查询子账户余额
     *
     * @return ApiResponse&lt;AdsQueryBalanceResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsQueryBalanceResponse> queryOwnerBalanceHttpInfo()
            throws ApiException {
        com.squareup.okhttp.Call call = queryOwnerBalanceBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<AdsQueryBalanceResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryOwnerBalanceBeforeCall(
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                queryOwnerBalanceAddCall(progressListener, progressRequestListener);
        return call;
    }


    /**
     * 查询子账户余额建立链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryOwnerBalanceAddCall(
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = null;
        // create path and map variables
        String localVarPath = "/v2/communal/owner/balance";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept","*/*");
        localVarHeaderParams.put("Content-Type","application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization",ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding","gzip,deflate,br");
        localVarHeaderParams.put("Connection","keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 查询代理商账户余额
     *
     * @return AdsQueryBalanceResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsQueryBalanceResponse queryAgencyBalance() throws ApiException {
        ApiResponse<AdsQueryBalanceResponse> resp = queryAgencyBalanceHttpInfo();
        return resp.getData();
    }

    /**
     * 查询代理商账户余额
     *
     * @return ApiResponse&lt;AdsQueryBalanceResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsQueryBalanceResponse> queryAgencyBalanceHttpInfo()
            throws ApiException {
        com.squareup.okhttp.Call call = queryAgencyBalanceBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<AdsQueryBalanceResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryAgencyBalanceBeforeCall(
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                queryAgencyBalanceAddCall(progressListener, progressRequestListener);
        return call;
    }


    /**
     * 查询代理商账户余额建立链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryAgencyBalanceAddCall(
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/communal/agency/balance";
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept","*/*");
        localVarHeaderParams.put("Content-Type","application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization",ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding","gzip,deflate,br");
        localVarHeaderParams.put("Connection","keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 代理商基础信息接口
     *
     * @return AdsQueryAgencyInfoResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsQueryAgencyInfoResponse queryAgencyInfo() throws ApiException {
        ApiResponse<AdsQueryAgencyInfoResponse> resp = queryAgencyInfoHttpInfo();
        return resp.getData();
    }

    /**
     * 代理商基础信息接口
     *
     * @return ApiResponse&lt;AdsQueryAgencyInfoResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsQueryAgencyInfoResponse> queryAgencyInfoHttpInfo()
            throws ApiException {
        com.squareup.okhttp.Call call = queryAgencyInfoBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<AdsQueryAgencyInfoResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryAgencyInfoBeforeCall(
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                queryAgencyInfoAddCall(progressListener, progressRequestListener);
        return call;
    }


    /**
     * 代理商基础信息接口建立链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryAgencyInfoAddCall(
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/communal/agency/info";
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept","*/*");
        localVarHeaderParams.put("Content-Type","application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization",ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding","gzip,deflate,br");
        localVarHeaderParams.put("Connection","keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 财务流水导出
     *
     * @return AdsBillsExportResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsBillsExportResponse billHisForm(AdsAccBillHisForm data,Integer type) throws ApiException {
        ApiResponse<AdsBillsExportResponse> resp = billHisFormHttpInfo(data,type);
        return resp.getData();
    }

    /**
     * 财务流水导出
     *
     * @return ApiResponse&lt;AdsBillsExportResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsBillsExportResponse> billHisFormHttpInfo(AdsAccBillHisForm data,Integer type)
            throws ApiException {
        com.squareup.okhttp.Call call = billHisFormBeforeCall(data,type,null, null);
        Type localVarReturnType = new TypeToken<AdsBillsExportResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call billHisFormBeforeCall(
            AdsAccBillHisForm data,
            Integer type,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                billHisFormAddCall(data,type,progressListener, progressRequestListener);
        return call;
    }


    /**
     * 财务流水导出接口建立链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call billHisFormAddCall(
            AdsAccBillHisForm data,
            Integer type,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/communal/finance/billHisExport";
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        localVarFormParams.put("loginType",type);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept","*/*");
        localVarHeaderParams.put("Content-Type","application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization",ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding","gzip,deflate,br");
        localVarHeaderParams.put("Connection","keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }
}
