package com.omni.ads.api;

import com.google.gson.reflect.TypeToken;
import com.omni.ads.baseconfig.*;
import com.omni.ads.model.adsbidconfig.AdsGetGroupPriceResponse;
import com.omni.ads.model.adsbidconfig.PriceConfigRequest;
import com.omni.ads.utils.JsonToMapUtils;
import com.omni.ads.utils.ThreadLocalUtil;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdsBidConfigApi {
    private ApiClient apiClient;

    public AdsBidConfigApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AdsBidConfigApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * 获取出价配置
     *
     * @return AdsQueryInsAppResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsGetGroupPriceResponse getGroupPrice(Integer showType, Integer extensionType) throws ApiException {
        ApiResponse<AdsGetGroupPriceResponse> resp = getGroupPriceWithHttpInfo(showType, extensionType);
        return resp.getData();
    }

    /**
     * 获取出价配置
     *
     * @return ApiResponse&lt;AdsQueryInsAppResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsGetGroupPriceResponse> getGroupPriceWithHttpInfo(Integer showType, Integer extensionType)
            throws ApiException {
        com.squareup.okhttp.Call call = getGroupPriceValidateBeforeCall(showType, extensionType, null, null);
        Type localVarReturnType = new TypeToken<AdsGetGroupPriceResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getGroupPriceValidateBeforeCall(
            Integer showType,
            Integer extensionType,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                getGroupPriceAddCall(showType, extensionType, progressListener, progressRequestListener);
        return call;
    }

    /**
     * 建立对获取出价配置的连接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getGroupPriceAddCall(
            Integer showType,
            Integer extensionType,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        PriceConfigRequest req = new PriceConfigRequest();
        req.setExtensionType(extensionType);
        req.setShowType(showType);
        Object localVarPostBody = req;

        String localVarPath = "/v2/communal/interval/config/groupPrice";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarFormParams.put("showType", showType);
        localVarFormParams.put("extensionType", extensionType);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }
}
