package com.omni.ads.api;

import com.google.gson.reflect.TypeToken;
import com.omni.ads.baseconfig.*;
import com.omni.ads.model.adscommunal.*;
import com.omni.ads.utils.JsonToMapUtils;
import com.omni.ads.utils.ThreadLocalUtil;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdsCommunalApi {
    private ApiClient apiClient;

    public AdsCommunalApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AdsCommunalApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * 根据配置类型获取配置项
     *
     * @return AdsCommunalResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsCommunalResponse configList(AdsConfigReq req) throws ApiException {
        ApiResponse<AdsCommunalResponse> resp = configListWithHttpInfo(req);
        return resp.getData();
    }

    /**
     * 根据配置类型获取配置项
     *
     * @return ApiResponse&lt;AdsCommunalResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsCommunalResponse> configListWithHttpInfo(AdsConfigReq req)
            throws ApiException {
        com.squareup.okhttp.Call call = configListValidateBeforeCall(req, null, null);
        Type localVarReturnType = new TypeToken<AdsCommunalResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call configListValidateBeforeCall(
            AdsConfigReq req,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        com.squareup.okhttp.Call call =
                configListAddCall(req, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 建立对'根据配置类型获取配置项'的连接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call configListAddCall(
            AdsConfigReq req,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = req;
        // create path and map variables
        String localVarPath = "/v3/communal/config/getList";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(req);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 根据配置类型批量获取配置项
     *
     * @return AdsCommunalGetMapResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsCommunalGetMapResponse configGetMap(AdsConfigReq req) throws ApiException {
        ApiResponse<AdsCommunalGetMapResponse> resp = configGetMapWithHttpInfo(req);
        return resp.getData();
    }

    /**
     * 根据配置类型批量获取配置项
     *
     * @return ApiResponse&lt;AdsCommunalGetMapResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsCommunalGetMapResponse> configGetMapWithHttpInfo(AdsConfigReq req)
            throws ApiException {
        com.squareup.okhttp.Call call = configGetMapValidateBeforeCall(req, null, null);
        Type localVarReturnType = new TypeToken<AdsCommunalGetMapResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call configGetMapValidateBeforeCall(
            AdsConfigReq req,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                configGetMapAddCall(req, progressListener, progressRequestListener);
        return call;
    }

    /**
     * 建立对'根据配置类型批量获取配置项'的连接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call configGetMapAddCall(
            AdsConfigReq req,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = req;
        // create path and map variables
        String localVarPath = "/v3/communal/config/getMap";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = JsonToMapUtils.getForm(req);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        ThreadLocalUtil.threadLocal.remove();
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }


    /**
     * 获取应用信息
     *
     * @return AdsCommunalGetAppInfoResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsCommunalGetAppInfoResponse getAppInfo(Integer appId, String pkgName, Integer bizType, Integer flowScene) throws ApiException {
        ApiResponse<AdsCommunalGetAppInfoResponse> resp = getAppInfoWithHttpInfo(appId, pkgName, bizType, flowScene);
        return resp.getData();
    }

    /**
     * 获取应用信息
     *
     * @return ApiResponse&lt;AdsCommunalGetAppInfoResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsCommunalGetAppInfoResponse> getAppInfoWithHttpInfo(Integer appId, String pkgName, Integer bizType, Integer flowScene)
            throws ApiException {
        com.squareup.okhttp.Call call = getAppInfoValidateBeforeCall(appId, pkgName, bizType, flowScene, null, null);
        Type localVarReturnType = new TypeToken<AdsCommunalGetAppInfoResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAppInfoValidateBeforeCall(
            Integer appId,
            String pkgName,
            Integer bizType,
            Integer flowScene,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                getAppInfoAddCall(appId, pkgName, bizType, flowScene, progressListener, progressRequestListener);
        return call;
    }

    /**
     * 建立对'获取应用信息'的连接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAppInfoAddCall(
            Integer appId,
            String pkgName,
            Integer bizType,
            Integer flowScene,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        GetAppInfoRequest info = new GetAppInfoRequest();
        info.setAppId(appId);
        info.setBizType(bizType);
        info.setPkgName(pkgName);
        info.setFlowScene(flowScene);
        Object localVarPostBody = info;
        String localVarPath = "/v2/communal/group/appInfo";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarFormParams.put("appId", appId);
        localVarFormParams.put("pkgName", pkgName);
        localVarFormParams.put("bizType", bizType);
        localVarFormParams.put("flowScene", flowScene);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 获取应用列表信息
     *
     * @return AdsCommunalAppListResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsCommunalAppListResponse getAppInfoList(AdsAppBatchSearchForm req) throws ApiException {
        ApiResponse<AdsCommunalAppListResponse> resp = getAppInfoListWithHttpInfo(req);
        return resp.getData();
    }

    /**
     * 获取应用列表信息
     *
     * @return ApiResponse&lt;AdsCommunalAppListResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsCommunalAppListResponse> getAppInfoListWithHttpInfo(AdsAppBatchSearchForm req)
            throws ApiException {
        com.squareup.okhttp.Call call = getAppInfoListValidateBeforeCall(req, null, null);
        Type localVarReturnType = new TypeToken<AdsCommunalAppListResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAppInfoListValidateBeforeCall(
            AdsAppBatchSearchForm req,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                getAppInfoListAddCall(req, progressListener, progressRequestListener);
        return call;
    }

    /**
     * 建立对'获取应用列表信息'的连接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAppInfoListAddCall(
            AdsAppBatchSearchForm req,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = req;
        // create path and map variables
        String localVarPath = "/v2/communal/group/appInfoList";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(req);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 获取动态通配符
     *
     * @return AdsCommunalSymbolResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsCommunalSymbolResponse getSymbolList(DynamicSymbolReq req) throws ApiException {
        ApiResponse<AdsCommunalSymbolResponse> resp = getSymbolListWithHttpInfo(req);
        return resp.getData();
    }

    /**
     * 获取动态通配符
     *
     * @return ApiResponse&lt;AdsCommunalSymbolResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsCommunalSymbolResponse> getSymbolListWithHttpInfo(DynamicSymbolReq req)
            throws ApiException {
        com.squareup.okhttp.Call call = getSymbolListValidateBeforeCall(req, null, null);
        Type localVarReturnType = new TypeToken<AdsCommunalSymbolResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSymbolListValidateBeforeCall(
            DynamicSymbolReq req,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                getSymbolListAddCall(req, progressListener, progressRequestListener);
        return call;
    }

    /**
     * 建立对'获取动态通配符'的连接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSymbolListAddCall(
            DynamicSymbolReq req,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = req;

        String localVarPath = "/v2/communal/dynamic/symbol/list";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(req);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 查询建站落地页
     *
     * @return AdsCommunalSparkPageResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsCommunalSparkPageResponse getSparkPage(AdsAdPageForm req) throws ApiException {
        ApiResponse<AdsCommunalSparkPageResponse> resp = getSparkPageWithHttpInfo(req);
        return resp.getData();
    }

    /**
     * 查询建站落地页
     *
     * @return ApiResponse&lt;AdsCommunalSparkPageResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsCommunalSparkPageResponse> getSparkPageWithHttpInfo(AdsAdPageForm req)
            throws ApiException {
        com.squareup.okhttp.Call call = getSparkPageValidateBeforeCall(req, null, null);
        Type localVarReturnType = new TypeToken<AdsCommunalSparkPageResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSparkPageValidateBeforeCall(
            AdsAdPageForm req,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                getSparkPageAddCall(req, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 建立对'查询建站落地页'的连接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSparkPageAddCall(
            AdsAdPageForm req,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = req;
        // create path and map variables
        String localVarPath = "/v2/communal/ad/sparkPageNew/list";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(req);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }


    /**
     * 查询规格列表
     *
     * @return AdsCommunalSpecResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsCommunalSpecResponse getSpec(AdsV3MtrSpecForm req) throws ApiException {
        ApiResponse<AdsCommunalSpecResponse> resp = getSpecWithHttpInfo(req);
        return resp.getData();
    }

    /**
     * 查询规格列表
     *
     * @return ApiResponse&lt;AdsCommunalSpecResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsCommunalSpecResponse> getSpecWithHttpInfo(AdsV3MtrSpecForm req)
            throws ApiException {
        com.squareup.okhttp.Call call = getSpecValidateBeforeCall(req, null, null);
        Type localVarReturnType = new TypeToken<AdsCommunalSpecResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSpecValidateBeforeCall(
            AdsV3MtrSpecForm req,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                getSpecAddCall(req, progressListener, progressRequestListener);
        return call;
    }

    /**
     * 建立对'查询规格列表'的连接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSpecAddCall(
            AdsV3MtrSpecForm req,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = req;
        // create path and map variables
        String localVarPath = "/v3/communal/spec/list";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(req);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 出价方式及限定范围查询
     *
     * @return AdsGroupPriceResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsGroupPriceResponse getPrice(Integer flowScene, Integer ocpcType, Integer extensionType) throws ApiException {
        ApiResponse<AdsGroupPriceResponse> resp = getPriceWithHttpInfo(flowScene, ocpcType, extensionType);
        return resp.getData();
    }

    /**
     * 出价方式及限定范围查询
     *
     * @return ApiResponse&lt;AdsGroupPriceResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsGroupPriceResponse> getPriceWithHttpInfo(Integer flowScene, Integer ocpcType, Integer extensionType)
            throws ApiException {
        com.squareup.okhttp.Call call = getPriceValidateBeforeCall(flowScene, ocpcType, extensionType, null, null);
        Type localVarReturnType = new TypeToken<AdsGroupPriceResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPriceValidateBeforeCall(
            Integer flowScene,
            Integer ocpcType,
            Integer extensionType,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                getPriceAddCall(flowScene, ocpcType, extensionType, progressListener, progressRequestListener);
        return call;
    }

    /**
     * 建立对'出价方式及限定范围查询'的连接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPriceAddCall(
            Integer flowScene,
            Integer ocpcType,
            Integer extensionType,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        AdsPriceReq req = new AdsPriceReq();
        req.setExtensionType(extensionType);
        req.setFlowScene(flowScene);
        req.setOcpcType(ocpcType);
        Object localVarPostBody = req;
        String localVarPath = "/v3/communal/interval/config/groupPrice";
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarFormParams.put("flowScene", flowScene);
        localVarFormParams.put("ocpcType", ocpcType);
        localVarFormParams.put("extensionType", extensionType);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

}
