package com.omni.ads.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.reflect.TypeToken;
import com.omni.ads.baseconfig.*;
import com.omni.ads.model.adscreativity.*;
import com.omni.ads.model.adscreativity.vo.AdsAdCollectReq;
import com.omni.ads.model.adscreativity.vo.AdsAdDelReq;
import com.omni.ads.utils.JsonToMapUtils;
import com.omni.ads.utils.ThreadLocalUtil;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.*;

public class AdsCreativityApi {
    private ApiClient apiClient;

    public AdsCreativityApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AdsCreativityApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * 获取单个广告创意
     *
     * @param adId (required)
     * @return AdgroupsAddResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsGetCreativityResponse getAdsCreativity(Long adId) throws ApiException {
        ApiResponse<AdsGetCreativityResponse> resp = getAdsWithHttpInfo(adId);
        return resp.getData();
    }

    /**
     * 获取单个广告创意
     *
     * @param adId (required)
     * @return ApiResponse&lt;AdsGetCreativityResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsGetCreativityResponse> getAdsWithHttpInfo(Long adId)
            throws ApiException {
        com.squareup.okhttp.Call call = getAdsValidateBeforeCall(adId, null, null);
        Type localVarReturnType = new TypeToken<AdsGetCreativityResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAdsValidateBeforeCall(
            Long adId,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        if (adId == null) {
            throw new ApiException(
                    "Missing the required parameter 'data' when calling adgroupsAdd(Async)");
        }
        com.squareup.okhttp.Call call =
                getAdsCreativityAddCall(adId, progressListener, progressRequestListener);
        return call;
    }

    /**
     * 建立对获取单个广告创意的连接
     *
     * @param adId                    (required)
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAdsCreativityAddCall(
            Long adId,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = adId;
        // create path and map variables
        String localVarPath = "/v3/ad/get";
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (adId != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("adId", adId));
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "GET",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 获取广告组下广告详情列表
     *
     * @param data (required)
     * @return AdgroupsAddResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsGetCreativityListOfAdResponse getAdsCreativityListOfAd(AdsAdCollectListReq data) throws ApiException {
        ApiResponse<AdsGetCreativityListOfAdResponse> resp = getAdsOfAdWithHttpInfo(data);
        return resp.getData();
    }

    /**
     * 获取广告组下广告详情列表
     *
     * @param data (required)
     * @return ApiResponse&lt;AdsGetCreativityResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsGetCreativityListOfAdResponse> getAdsOfAdWithHttpInfo(AdsAdCollectListReq data)
            throws ApiException {
        com.squareup.okhttp.Call call = getAdsOfAdValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsGetCreativityListOfAdResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAdsOfAdValidateBeforeCall(
            AdsAdCollectListReq data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        if (data == null) {
            throw new ApiException(
                    "Missing the required parameter 'data' when calling adgroupsAdd(Async)");
        }
        com.squareup.okhttp.Call call =
                getAdsCreativityOfAdAddCall(data, progressListener, progressRequestListener);
        return call;
    }

    /**
     * 建立对获取广告组下广告详情列表的连接
     *
     * @param data                    (required)
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAdsCreativityOfAdAddCall(
            AdsAdCollectListReq data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = data;

        // create path and map variables
        String localVarPath = "/v3/ad/list";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");

        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 分页获取广告创意列表
     *
     * @param data (required)
     * @return AdsGetListByPageResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsGetListByPageResponse getAdsListByPage(AdsAdListForm data) throws ApiException {
        ApiResponse<AdsGetListByPageResponse> resp = getAdsListByPageWithHttpInfo(data);
        return resp.getData();
    }

    /**
     * 分页获取广告创意
     *
     * @param data (required)
     * @return ApiResponse&lt;AdsGetListByPageResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsGetListByPageResponse> getAdsListByPageWithHttpInfo(AdsAdListForm data)
            throws ApiException {
        com.squareup.okhttp.Call call = getAdsListByPageValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsGetListByPageResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAdsListByPageValidateBeforeCall(
            AdsAdListForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        if (data == null) {
            throw new ApiException(
                    "Missing the required parameter 'data' when calling adgroupsAdd(Async)");
        }
        com.squareup.okhttp.Call call =
                getAdsListByPageByCall(data, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 建立对分页获取广告创意列表接口的连接
     *
     * @param data (required)
     * @return AdgroupsAddResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public com.squareup.okhttp.Call getAdsListByPageByCall(
            AdsAdListForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener
    ) throws ApiException {
        Object localVarPostBody = data;
        //接口地址
        String localVarPath = "/v3/ad/page";
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }


    /**
     * 批量启停广告创意
     *
     * @param adForm (required)
     * @return AdsBatchEditStatusResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsBatchEditStatusResponse batchEditAdStatus(AdsAdStatusForm adForm) throws ApiException {
        ApiResponse<AdsBatchEditStatusResponse> resp = batchEditAdStatusWithHttpInfo(adForm);
        return resp.getData();
    }

    /**
     * 批量启停广告创意
     *
     * @param adForm (required)
     * @return ApiResponse&lt;AdsBatchEditStatusResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsBatchEditStatusResponse> batchEditAdStatusWithHttpInfo(AdsAdStatusForm adForm)
            throws ApiException {
        com.squareup.okhttp.Call call = batchEditAdStatusValidateBeforeCall(adForm, null, null);
        Type localVarReturnType = new TypeToken<AdsBatchEditStatusResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call batchEditAdStatusValidateBeforeCall(
            AdsAdStatusForm adForm,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        if (adForm == null) {
            throw new ApiException(
                    "Missing the required parameter 'data' when calling adgroupsAdd(Async)");
        }
        com.squareup.okhttp.Call call =
                batchEditAdStatusByCall(adForm, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 建立对批量启停广告创意接口的连接
     *
     * @param adForm (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public com.squareup.okhttp.Call batchEditAdStatusByCall(
            AdsAdStatusForm adForm,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener
    ) throws ApiException {
        Object localVarPostBody = adForm;
        //接口地址
        String localVarPath = "/v3/ad/status";
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(adForm);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 批量操作广告创意(新增/编辑/删除)广告创意(新增和编辑限制同一个广告组下，删除不限制，可操作1-50个)
     *
     * @param data (required)
     * @return AdsBatchOprateAdsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsBatchOprateAdsResponse batchOprateAds(AdsAdCollectBatchReq data) throws ApiException {
        ApiResponse<AdsBatchOprateAdsResponse> resp = batchOprateAdsWithHttpInfo(data);
        return resp.getData();
    }

    /**
     * 批量操作广告创意(新增/编辑/删除)广告创意
     *
     * @param data (required)
     * @return ApiResponse&lt;AdsBatchOprateAdsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsBatchOprateAdsResponse> batchOprateAdsWithHttpInfo(AdsAdCollectBatchReq data)
            throws ApiException {
        com.squareup.okhttp.Call call = batchOprateAdsValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsBatchOprateAdsResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call batchOprateAdsValidateBeforeCall(
            AdsAdCollectBatchReq data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        if (data == null) {
            throw new ApiException(
                    "Missing the required parameter 'data' when calling adgroupsAdd(Async)");
        }
        com.squareup.okhttp.Call call =
                batchOprateAdsByCall(data, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 建立对批量操作广告创意(新增/编辑/删除)广告创意接口的连接
     *
     * @param data (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public com.squareup.okhttp.Call batchOprateAdsByCall(
            AdsAdCollectBatchReq data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener
    ) throws ApiException {
        Object localVarPostBody = data;
        //接口地址
        String localVarPath = "/v3/ad/batch";
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        Map<String, Object> map = new HashMap<>();
        List<AdsAdCollectReq> addList = data.getAddList();
        if (!CollectionUtils.isEmpty(addList)) {
            for (int i = 0; i < addList.size(); i++) {
                String jsonStr = JSONObject.toJSONString(addList.get(i));
                Map<String, Object> maps = (Map<String, Object>) JSON.parse(jsonStr);
                JSONObject jsonObject = JSONObject.parseObject(jsonStr);
                Set<String> strings = jsonObject.keySet();
                for (String str : strings) {
                    map.put("addList[" + i + "]." + str, maps.get(str));
                }
            }
            localVarFormParams.putAll(map);
        }
        List<AdsAdCollectReq> editList = data.getEditList();
        if (!CollectionUtils.isEmpty(editList)) {
            for (int i = 0; i < editList.size(); i++) {
                String jsonStr = JSONObject.toJSONString(editList.get(i));
                Map<String, Object> maps = (Map<String, Object>) JSON.parse(jsonStr);
                JSONObject jsonObject = JSONObject.parseObject(jsonStr);
                Set<String> strings = jsonObject.keySet();
                for (String str : strings) {
                    map.put("editList[" + i + "]." + str, maps.get(str));
                }
            }
            localVarFormParams.putAll(map);
        }
        List<AdsAdDelReq> delList = data.getDelList();
        if (!CollectionUtils.isEmpty(delList)) {
            for (int i = 0; i < delList.size(); i++) {
                String jsonStr = JSONObject.toJSONString(delList.get(i));
                Map<String, Object> maps = (Map<String, Object>) JSON.parse(jsonStr);
                JSONObject jsonObject = JSONObject.parseObject(jsonStr);
                Set<String> strings = jsonObject.keySet();
                for (String str : strings) {
                    map.put("delList[" + i + "]." + str, maps.get(str));
                }
            }
            localVarFormParams.putAll(map);
        }

        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");

        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 批量复制广告创意
     *
     * @param data (required)
     * @return AdsBatchOprateAdsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsBatchReplicateResponse batchReplicateAds(AdsAdReplicateForm data) throws ApiException {
        ApiResponse<AdsBatchReplicateResponse> resp = batchReplicateAdsWithHttpInfo(data);
        return resp.getData();
    }

    /**
     * 批量操作广告创意(新增/编辑/删除)广告创意
     *
     * @param data (required)
     * @return ApiResponse&lt;AdsBatchOprateAdsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsBatchReplicateResponse> batchReplicateAdsWithHttpInfo(AdsAdReplicateForm data)
            throws ApiException {
        com.squareup.okhttp.Call call = batchReplicateAdsValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsBatchReplicateResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call batchReplicateAdsValidateBeforeCall(
            AdsAdReplicateForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        if (data == null) {
            throw new ApiException(
                    "Missing the required parameter 'data' when calling adgroupsAdd(Async)");
        }
        com.squareup.okhttp.Call call =
                batchReplicateAdsByCall(data, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 建立对批量操作广告创意(新增/编辑/删除)广告创意接口的连接
     *
     * @param data (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public com.squareup.okhttp.Call batchReplicateAdsByCall(
            AdsAdReplicateForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener
    ) throws ApiException {
        Object localVarPostBody = data;
        //接口地址
        String localVarPath = "/v3/ad/batchReplicate";
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 2.0+3.0广告分页查询
     *
     * @param data (required)
     * @return AdsBatchOprateAdsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsGetAllListResponse getAllList(AdsAllAdListForm data) throws ApiException {
        ApiResponse<AdsGetAllListResponse> resp = getAllListWithHttpInfo(data);
        return resp.getData();
    }

    /**
     * 批量操作广告创意(新增/编辑/删除)广告创意
     *
     * @param data (required)
     * @return ApiResponse&lt;AdsBatchOprateAdsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsGetAllListResponse> getAllListWithHttpInfo(AdsAllAdListForm data)
            throws ApiException {
        com.squareup.okhttp.Call call = getAllListValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsGetAllListResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAllListValidateBeforeCall(
            AdsAllAdListForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        if (data == null) {
            throw new ApiException(
                    "Missing the required parameter 'data' when calling adgroupsAdd(Async)");
        }
        com.squareup.okhttp.Call call =
                getAllListByCall(data, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 建立对批量操作广告创意(新增/编辑/删除)广告创意接口的连接
     *
     * @param data (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public com.squareup.okhttp.Call getAllListByCall(
            AdsAllAdListForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener
    ) throws ApiException {
        Object localVarPostBody = data;
        //接口地址
        String localVarPath = "/v3/ad/allList";
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

}
