package com.omni.ads.api;

import com.google.gson.reflect.TypeToken;
import com.omni.ads.baseconfig.*;
import com.omni.ads.model.adsinstantapp.*;
import com.omni.ads.utils.JsonToMapUtils;
import com.omni.ads.utils.ThreadLocalUtil;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdsInstantAppApi {
    private ApiClient apiClient;

    public AdsInstantAppApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AdsInstantAppApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * 查询快应用相关信息
     *
     * @return AdsQueryInsAppResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsQueryInsAppResponse queryInsApp(AdInstantAppForm data) throws ApiException {
        ApiResponse<AdsQueryInsAppResponse> resp = queryInsAppWithHttpInfo(data);
        return resp.getData();
    }

    /**
     * 查询快应用相关信息
     *
     * @return ApiResponse&lt;AdsQueryInsAppResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsQueryInsAppResponse> queryInsAppWithHttpInfo(AdInstantAppForm data)
            throws ApiException {
        com.squareup.okhttp.Call call = queryInsAppValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsQueryInsAppResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryInsAppValidateBeforeCall(
            AdInstantAppForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                queryInsAppAddCall(data, progressListener, progressRequestListener);
        return call;
    }

    /**
     * 建立对查询快应用相关信息的连接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryInsAppAddCall(
            AdInstantAppForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = data;
        String localVarPath = "/v2/communal/instant/appInfo";
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 查询快应用键入历史
     *
     * @return AdsQueryInsAppResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsQueryInsAppHistoryResponse queryInsAppHistory(Integer inputAppId) throws ApiException {
        ApiResponse<AdsQueryInsAppHistoryResponse> resp = queryInsAppHistoryWithHttpInfo(inputAppId);
        return resp.getData();
    }

    /**
     * 查询快应用键入历史
     *
     * @return ApiResponse&lt;AdsQueryInsAppResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsQueryInsAppHistoryResponse> queryInsAppHistoryWithHttpInfo(Integer inputAppId)
            throws ApiException {
        com.squareup.okhttp.Call call = queryInsAppHistoryValidateBeforeCall(inputAppId, null, null);
        Type localVarReturnType = new TypeToken<AdsQueryInsAppHistoryResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryInsAppHistoryValidateBeforeCall(
            Integer inputAppId,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                queryInsAppHistoryAddCall(inputAppId, progressListener, progressRequestListener);
        return call;
    }

    /**
     * 建立对查询快应用键入历史的连接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryInsAppHistoryAddCall(
            Integer inputAppId,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = inputAppId;

        String localVarPath = "/v2/communal/instant/listHistoryAppInfo";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarFormParams.put("inputAppId", inputAppId);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 快应用校验
     *
     * @return AdsQuickAppResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsQuickAppResponse quickApp(AdV3InstantAppForm data) throws ApiException {
        ApiResponse<AdsQuickAppResponse> resp = quickAppWithHttpInfo(data);
        return resp.getData();
    }

    /**
     * 快应用校验
     *
     * @return ApiResponse&lt;AdsQuickAppResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsQuickAppResponse> quickAppWithHttpInfo(AdV3InstantAppForm data)
            throws ApiException {
        com.squareup.okhttp.Call call = quickAppValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsQuickAppResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call quickAppValidateBeforeCall(
            AdV3InstantAppForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                quickAppAddCall(data, progressListener, progressRequestListener);
        return call;
    }

    /**
     * 快应用校验建立连接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call quickAppAddCall(
            AdV3InstantAppForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = data;
        String localVarPath = "/v3/communal/instant/check";
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }
}
