package com.omni.ads.api;

import com.google.gson.reflect.TypeToken;
import com.omni.ads.baseconfig.*;
import com.omni.ads.model.adscreativity.vo.AdsAdMaterialVo;
import com.omni.ads.model.adsdata.AdsDataResponse;
import com.omni.ads.model.material.*;
import com.omni.ads.utils.JsonToMapUtils;
import com.omni.ads.utils.ThreadLocalUtil;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdsMaterialApi {
    private ApiClient apiClient;

    public AdsMaterialApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AdsMaterialApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * 获取素材规格
     *
     * @return AdsMaterialSpecQueryResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsMaterialSpecQueryResponse queryMaterialSpec(AdsMtrSpecForm data) throws ApiException {
        ApiResponse<AdsMaterialSpecQueryResponse> resp = queryMaterialSpecWithHttpInfo(data);
        return resp.getData();
    }

    /**
     * 获取素材规格
     *
     * @return ApiResponse&lt;AdsMaterialSpecQueryResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsMaterialSpecQueryResponse> queryMaterialSpecWithHttpInfo(AdsMtrSpecForm data)
            throws ApiException {
        com.squareup.okhttp.Call call = queryMaterialSpecValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsMaterialSpecQueryResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryMaterialSpecValidateBeforeCall(
            AdsMtrSpecForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                queryMaterialSpecAddCall(data, progressListener, progressRequestListener);
        return call;
    }

    /**
     * 建立对获取素材规格的连接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryMaterialSpecAddCall(
            AdsMtrSpecForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = data;
        String localVarPath = "/v2/communal/material/spec/list";
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 查询showType相关信息
     *
     * @return AdsMaterialgetShowTypeResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsMaterialgetShowTypeResponse queryShowType(Integer showType) throws ApiException {
        ApiResponse<AdsMaterialgetShowTypeResponse> resp = queryShowTypeWithHttpInfo(showType);
        return resp.getData();
    }

    /**
     * 查询showType相关信息
     *
     * @return ApiResponse&lt;AdsMaterialgetShowTypeResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsMaterialgetShowTypeResponse> queryShowTypeWithHttpInfo(Integer showType)
            throws ApiException {
        com.squareup.okhttp.Call call = queryShowTypeValidateBeforeCall(showType, null, null);
        Type localVarReturnType = new TypeToken<AdsMaterialgetShowTypeResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryShowTypeValidateBeforeCall(
            Integer showType,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                queryShowTypeAddCall(showType, progressListener, progressRequestListener);
        return call;
    }

    /**
     * 建立对查询showType相关信息的连接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryShowTypeAddCall(
            Integer showType,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = showType;
        String localVarPath = "/v2/communal/material/showType/get";
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarFormParams.put("showType", showType);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 获取模板列表
     *
     * @return AdsMaterialGetH5TemplateResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsMaterialGetH5TemplateResponse getH5Template(AdsV3H5TemplateForm data) throws ApiException {
        ApiResponse<AdsMaterialGetH5TemplateResponse> resp = getH5TemplateWithHttpInfo(data);
        return resp.getData();
    }

    /**
     * 获取模板列表
     *
     * @return ApiResponse&lt;AdsMaterialGetH5TemplateResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsMaterialGetH5TemplateResponse> getH5TemplateWithHttpInfo(AdsV3H5TemplateForm data)
            throws ApiException {
        com.squareup.okhttp.Call call = getH5TemplateValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsMaterialGetH5TemplateResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getH5TemplateValidateBeforeCall(
            AdsV3H5TemplateForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                getH5TemplateAddCall(data, progressListener, progressRequestListener);
        return call;
    }

    /**
     * 建立对获取模板列表的连接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getH5TemplateAddCall(
            AdsV3H5TemplateForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = data;
        String localVarPath = "/v3/communal/h5Template/list";
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 获取图片列表
     *
     * @return AdsMaterialGetH5TemplateResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsMaterialPictureResponse getListMaterialPicture(AdsAdMaterialVo data) throws ApiException {
        ApiResponse<AdsMaterialPictureResponse> resp = getPictureWithHttpInfo(data);
        return resp.getData();
    }

    /**
     * 获取图片列表
     *
     * @return ApiResponse&lt;AdsMaterialGetH5TemplateResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsMaterialPictureResponse> getPictureWithHttpInfo(AdsAdMaterialVo data)
            throws ApiException {
        com.squareup.okhttp.Call call = getPictureBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsMaterialPictureResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPictureBeforeCall(
            AdsAdMaterialVo data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                getPictureAddCall(data, progressListener, progressRequestListener);
        return call;
    }

    /**
     * 建立对获取图片列表的连接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPictureAddCall(
            AdsAdMaterialVo data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = data;
        String localVarPath = "/v2/communal/material/list";
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 分页获取广告主素材
     *
     * @return AdsMaterialPageListResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsMaterialPageListResponse getMaterialPageList(AdsAdMaterialForm data) throws ApiException {
        ApiResponse<AdsMaterialPageListResponse> resp = getMaterialPageListWithHttpInfo(data);
        return resp.getData();
    }

    /**
     * 分页获取广告主素材
     *
     * @return ApiResponse&lt;AdsMaterialPageListResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsMaterialPageListResponse> getMaterialPageListWithHttpInfo(AdsAdMaterialForm data)
            throws ApiException {
        com.squareup.okhttp.Call call = getMaterialPageListBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsMaterialPageListResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getMaterialPageListBeforeCall(
            AdsAdMaterialForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                getMaterialPageListAddCall(data, progressListener, progressRequestListener);
        return call;
    }

    /**
     * 建立对分页获取广告主素材的连接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getMaterialPageListAddCall(
            AdsAdMaterialForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = data;
        String localVarPath = "/v2/communal/material/pageList";
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 素材上传
     *
     * @return AdsDataResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsDataResponse materialCommunalUpload(AdsMtFileForm map) throws ApiException {
        ApiResponse<AdsDataResponse> resp = materialCommunalUploadHttpInfo(map);
        return resp.getData();
    }

    /**
     * 素材上传
     *
     * @param map (required)
     * @return ApiResponse&lt;AdsDataResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsDataResponse> materialCommunalUploadHttpInfo(AdsMtFileForm map)
            throws ApiException {
        com.squareup.okhttp.Call call = materialCommunalUploadBeforeCall(map, null, null);
        Type localVarReturnType = new TypeToken<AdsDataResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call materialCommunalUploadBeforeCall(
            AdsMtFileForm map,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        if (map == null) {
            throw new ApiException(
                    "Missing the required parameter 'data' ");
        }
        com.squareup.okhttp.Call call =
                materialCommunalUploadAddCall(map, progressListener, progressRequestListener);
        return call;
    }

    /**
     * 建立对 素材上传 的连接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call materialCommunalUploadAddCall(
            AdsMtFileForm map,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = map;
        String localVarPath = "/v3/creative/material/communal/upload";
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(map);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"multipart/form-data"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        localVarHeaderParams.put("Content-Type", "multipart/form-data");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 素材查询
     *
     * @return AdsDataResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsDataResponse getQueryMt(Map<String, Object> map) throws ApiException {
        ApiResponse<AdsDataResponse> resp = getQueryMtHttpInfo(map);
        return resp.getData();
    }

    /**
     * 素材查询
     *
     * @param map (required)
     * @return ApiResponse&lt;AdsDataResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsDataResponse> getQueryMtHttpInfo(Map<String, Object> map)
            throws ApiException {
        com.squareup.okhttp.Call call = getQueryMtBeforeCall(map, null, null);
        Type localVarReturnType = new TypeToken<AdsDataResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getQueryMtBeforeCall(
            Map<String, Object> map,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        if (map == null) {
            throw new ApiException(
                    "Missing the required parameter 'data' ");
        }
        com.squareup.okhttp.Call call =
                getQueryMtAddCall(map, progressListener, progressRequestListener);
        return call;
    }

    /**
     * 建立对 素材查询 的连接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getQueryMtAddCall(
            Map<String, Object> map,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = map;
        String localVarPath = "/v3/creative/material/communal/query";
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (map != null) {
            if (map.get("pageSize") != null) {
                localVarQueryParams.addAll(apiClient.parameterToPair("pageSize", map.get("pageSize")));
            }
            if (map.get("pageNum") != null) {
                localVarQueryParams.addAll(apiClient.parameterToPair("pageNum", map.get("pageNum")));
            }
            if (map.get("aspectRatios") != null) {
                localVarQueryParams.addAll(apiClient.parameterToPair("aspectRatios", map.get("aspectRatios")));
            }
            if (map.get("aspectRatios") != null) {
                localVarQueryParams.addAll(apiClient.parameterToPair("aspectRatios", map.get("aspectRatios")));
            }
            if (map.get("suffixes") != null) {
                localVarQueryParams.addAll(apiClient.parameterToPair("suffixes", map.get("suffixes")));
            }
        }
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        localVarHeaderParams.put("Content-type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "GET",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 素材上传
     *
     * @return AdsDataResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsDataResponse uploadDepot(AdsMtForm form) throws ApiException {
        ApiResponse<AdsDataResponse> resp = uploadDepotHttpInfo(form);
        return resp.getData();
    }

    /**
     * 素材上传
     *
     * @param form (required)
     * @return ApiResponse&lt;AdsDataResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsDataResponse> uploadDepotHttpInfo(AdsMtForm form)
            throws ApiException {
        com.squareup.okhttp.Call call = uploadDepotBeforeCall(form, null, null);
        Type localVarReturnType = new TypeToken<AdsDataResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call uploadDepotBeforeCall(
            AdsMtForm form,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        if (form == null) {
            throw new ApiException(
                    "Missing the required parameter 'data' ");
        }
        com.squareup.okhttp.Call call =
                uploadDepotAddCall(form, progressListener, progressRequestListener);
        return call;
    }

    /**
     * 建立对 素材上传 的连接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call uploadDepotAddCall(
            AdsMtForm form,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = form;
        String localVarPath = "/v3/creative/material/communal/uploadDepot";
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> formMap = JsonToMapUtils.getForm(form);
        localVarFormParams.putAll(formMap);
        final String[] localVarAccepts = {"multipart/form-data"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        localVarHeaderParams.put("Content-Type", "multipart/form-data");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

}
