package com.omni.ads.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.reflect.TypeToken;
import com.omni.ads.baseconfig.*;
import com.omni.ads.model.adscreativity.AdsBatchReplicateResponse;
import com.omni.ads.model.adssearchkeyword.*;
import com.omni.ads.utils.JsonToMapUtils;
import com.omni.ads.utils.ThreadLocalUtil;
import org.springframework.util.CollectionUtils;

import javax.validation.Valid;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.*;

public class AdsSearchKeyWordApi {
    private ApiClient apiClient;

    public AdsSearchKeyWordApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AdsSearchKeyWordApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * 查询行业词包
     *
     * @return AdsQueryIndustryWordsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsQueryIndustryWordsResponse queryIndustryWord(AdSearchCategoryKwQueryDTO data) throws ApiException {
        ApiResponse<AdsQueryIndustryWordsResponse> resp = queryIndustryWordHttpInfo(data);
        return resp.getData();
    }

    /**
     * 查询行业词包
     *
     * @return ApiResponse&lt;AdsQueryIndustryWordsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsQueryIndustryWordsResponse> queryIndustryWordHttpInfo(AdSearchCategoryKwQueryDTO data)
            throws ApiException {
        com.squareup.okhttp.Call call = queryIndustryWordBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsQueryIndustryWordsResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryIndustryWordBeforeCall(
            AdSearchCategoryKwQueryDTO data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                queryIndustryWordAddCall(data, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 查询行业词包建立链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryIndustryWordAddCall(
            AdSearchCategoryKwQueryDTO data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = null;
        // create path and map variables
        String localVarPath = "/v3/communal/searchKeyWord/listCategoryKws";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 查询出价词
     *
     * @return AdsQueryPriceWordsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsQueryPriceWordsResponse queryPriceWord(AdSearchPremiumKwQueryDTO data) throws ApiException {
        ApiResponse<AdsQueryPriceWordsResponse> resp = queryPriceWordHttpInfo(data);
        return resp.getData();
    }

    /**
     * 查询出价词
     *
     * @return ApiResponse&lt;AdsQueryPriceWordsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsQueryPriceWordsResponse> queryPriceWordHttpInfo(AdSearchPremiumKwQueryDTO data)
            throws ApiException {
        com.squareup.okhttp.Call call = queryPriceWordBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsQueryPriceWordsResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryPriceWordBeforeCall(
            AdSearchPremiumKwQueryDTO data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                queryPriceWordAddCall(data, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 查询出价词建立链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryPriceWordAddCall(
            AdSearchPremiumKwQueryDTO data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = null;
        // create path and map variables
        String localVarPath = "/v3/communal/searchKeyWord/listPremiumKws";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        localVarHeaderParams.put("Content-Type", "application/json");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 查询广告主所有自定义词包
     *
     * @return AdsQueryPackageResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsQueryPackageResponse queryPackage(PremiumCustomKwDTO data) throws ApiException {
        ApiResponse<AdsQueryPackageResponse> resp = queryPackageHttpInfo(data);
        return resp.getData();
    }

    /**
     * 查询广告主所有自定义词包
     *
     * @return ApiResponse&lt;AdsQueryPackageResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsQueryPackageResponse> queryPackageHttpInfo(PremiumCustomKwDTO data)
            throws ApiException {
        com.squareup.okhttp.Call call = queryPackageBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsQueryPackageResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryPackageBeforeCall(
            PremiumCustomKwDTO data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                queryPackageAddCall(data, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 查询广告主所有自定义词包建立链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryPackageAddCall(
            PremiumCustomKwDTO data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = null;
        // create path and map variables
        String localVarPath = "/v3/communal/searchKeyWord/queryPackageByOwner";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 查询广告组下的关键词、行业类目词包、自定义词包或禁推词包
     *
     * @return AdsQueryPriceWordsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsQueryPriceWordsResponse queryKeyWords(ListGroupKwPkgForm data) throws ApiException {
        ApiResponse<AdsQueryPriceWordsResponse> resp = queryKeyWordsHttpInfo(data);
        return resp.getData();
    }

    /**
     * 查询广告组下的关键词、行业类目词包、自定义词包或禁推词包
     *
     * @return ApiResponse&lt;AdsQueryPriceWordsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsQueryPriceWordsResponse> queryKeyWordsHttpInfo(ListGroupKwPkgForm data)
            throws ApiException {
        com.squareup.okhttp.Call call = queryKeyWordsBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsQueryPriceWordsResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryKeyWordsBeforeCall(
            ListGroupKwPkgForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                queryKeyWordsAddCall(data, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 查询广告组下的关键词、行业类目词包、自定义词包或禁推词包建立链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryKeyWordsAddCall(
            ListGroupKwPkgForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = data;
        // create path and map variables
        String localVarPath = "/v3/communal/searchKeyWord/listGroupKwPkg";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }


    /**
     * 新增自定义词包，禁推词包
     *
     * @return AdsAddDefineWordsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsAddDefineWordsResponse addKeyWords(AddCustomKwPkgForm data) throws ApiException {
        ApiResponse<AdsAddDefineWordsResponse> resp = addKeyWordsHttpInfo(data);
        return resp.getData();
    }

    /**
     * 新增自定义词包，禁推词包
     *
     * @return ApiResponse&lt;AdsAddDefineWordsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsAddDefineWordsResponse> addKeyWordsHttpInfo(AddCustomKwPkgForm data)
            throws ApiException {
        com.squareup.okhttp.Call call = addKeyWordsBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsAddDefineWordsResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call addKeyWordsBeforeCall(
            AddCustomKwPkgForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                addKeyWordsAddCall(data, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 新增自定义词包，禁推词包--键连接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call addKeyWordsAddCall(
            AddCustomKwPkgForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = data;
        // create path and map variables
        String localVarPath = "/v3/communal/searchKeyWord/addCustomOrNoKwPkg";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        List<PkgKeywordForm> pkgList = data.getPkgKeywords();
        Map<String, Object> map = new HashMap<>();
        if (!CollectionUtils.isEmpty(pkgList)) {
            for (int i = 0; i < pkgList.size(); i++) {
                String jsonStr = JSONObject.toJSONString(pkgList.get(i));
                Map<String, Object> maps = (Map<String, Object>) JSON.parse(jsonStr);
                JSONObject jsonObject = JSONObject.parseObject(jsonStr);
                Set<String> strings = jsonObject.keySet();
                for (String str : strings) {
                    map.put("pkgKeywords[" + i + "]." + str, maps.get(str));
                }
            }
            localVarFormParams.putAll(map);
        }
        String kwPackageName = data.getKwPackageName();
        if (kwPackageName != null) {
            localVarFormParams.put("kwPackageName", data.getKwPackageName());
        }
        Integer kwPackageType = data.getKwPackageType();
        if (kwPackageType != null) {
            localVarFormParams.put("kwPackageType", data.getKwPackageType());
        }

        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }


    /**
     * 删除自定义词包，禁推词包
     *
     * @return AdsAddDefineWordsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsAddDefineWordsResponse delKeyWords(DeleteKwInPkgForm data) throws ApiException {
        ApiResponse<AdsAddDefineWordsResponse> resp = delKeyWordsHttpInfo(data);
        return resp.getData();
    }

    /**
     * 删除自定义词包，禁推词包
     *
     * @return ApiResponse&lt;AdsAddDefineWordsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsAddDefineWordsResponse> delKeyWordsHttpInfo(DeleteKwInPkgForm data)
            throws ApiException {
        com.squareup.okhttp.Call call = delKeyWordsBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsAddDefineWordsResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call delKeyWordsBeforeCall(
            DeleteKwInPkgForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                delKeyWordsAddCall(data, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 删除自定义词包，禁推词包--键连接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call delKeyWordsAddCall(
            DeleteKwInPkgForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = data;
        // create path and map variables
        String localVarPath = "/v3/communal/searchKeyWord/deleteKwInPkg";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 为已经存在的自定义词包、禁推词包添加关键词
     *
     * @return AdsBatchReplicateResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsBatchReplicateResponse addKeyWordsToPkg(AddKwToPkgForm data) throws ApiException {
        ApiResponse<AdsBatchReplicateResponse> resp = addToPkgHttpInfo(data);
        return resp.getData();
    }

    /**
     * 为已经存在的自定义词包、禁推词包添加关键词
     *
     * @return ApiResponse&lt;AdsBatchReplicateResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsBatchReplicateResponse> addToPkgHttpInfo(AddKwToPkgForm data)
            throws ApiException {
        com.squareup.okhttp.Call call = addToPkgBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsBatchReplicateResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call addToPkgBeforeCall(
            AddKwToPkgForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                addToPkgAddCall(data, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 为已经存在的自定义词包、禁推词包添加关键词--建立链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call addToPkgAddCall(
            AddKwToPkgForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = data;
        // create path and map variables
        String localVarPath = "/v3/communal/searchKeyWord/addKwToPkg";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }


    /**
     * 辑自定义词包、禁推词包词包名称，编辑词包中关键词的匹配模式
     *
     * @return AdsBatchReplicateResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsBatchReplicateResponse editCustomOrNoKwPkg(EditKwPkgForm data) throws ApiException {
        ApiResponse<AdsBatchReplicateResponse> resp = editCustomOrNoKwPkgHttpInfo(data);
        return resp.getData();
    }

    /**
     * 辑自定义词包、禁推词包词包名称，编辑词包中关键词的匹配模式
     *
     * @return ApiResponse&lt;AdsBatchReplicateResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsBatchReplicateResponse> editCustomOrNoKwPkgHttpInfo(EditKwPkgForm data)
            throws ApiException {
        com.squareup.okhttp.Call call = editCustomOrNoKwPkgBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsBatchReplicateResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call editCustomOrNoKwPkgBeforeCall(
            EditKwPkgForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                editCustomOrNoKwPkgAddCall(data, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 辑自定义词包、禁推词包词包名称，编辑词包中关键词的匹配模式--建立链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call editCustomOrNoKwPkgAddCall(
            EditKwPkgForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = data;
        // create path and map variables
        String localVarPath = "/v3/communal/searchKeyWord/editCustomOrNoKwPkg";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> map = new HashMap<>();
        List<PkgKeywordForm> pkgList = data.getPkgKeywords();
        if (!CollectionUtils.isEmpty(pkgList)) {
            for (int i = 0; i < pkgList.size(); i++) {
                String jsonStr = JSONObject.toJSONString(pkgList.get(i));
                Map<String, Object> maps = (Map<String, Object>) JSON.parse(jsonStr);
                JSONObject jsonObject = JSONObject.parseObject(jsonStr);
                Set<String> strings = jsonObject.keySet();
                for (String str : strings) {
                    map.put("pkgKeywords[" + i + "]." + str, maps.get(str));
                }
            }
            localVarFormParams.putAll(map);
        }
        localVarFormParams.put("kwPackageName", data.getKwPackageName());
        localVarFormParams.put("kwPackageId", data.getKwPackageId());
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 辑自定义词包、禁推词包词包名称，编辑词包中关键词的匹配模式
     *
     * @return AdsBatchReplicateResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsBatchReplicateResponse batchDeleteKwPkg(BatchDeleteKwPkgForm data) throws ApiException {
        ApiResponse<AdsBatchReplicateResponse> resp = batchDelHttpInfo(data);
        return resp.getData();
    }

    /**
     * 辑自定义词包、禁推词包词包名称，编辑词包中关键词的匹配模式
     *
     * @return ApiResponse&lt;AdsBatchReplicateResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsBatchReplicateResponse> batchDelHttpInfo(BatchDeleteKwPkgForm data)
            throws ApiException {
        com.squareup.okhttp.Call call = batchDelBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsBatchReplicateResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call batchDelBeforeCall(
            BatchDeleteKwPkgForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                batchDelAddCall(data, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 辑自定义词包、禁推词包词包名称，编辑词包中关键词的匹配模式--建立链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call batchDelAddCall(
            BatchDeleteKwPkgForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = data;
        // create path and map variables
        String localVarPath = "/v3/communal/searchKeyWord/batchDeleteKwPkg";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> map = new HashMap<>();
        List<Long> kwPkgIdList = data.getKwPkgIdList();
        if (!CollectionUtils.isEmpty(kwPkgIdList)) {
            for (int i = 0; i < kwPkgIdList.size(); i++) {
                Long aLong = kwPkgIdList.get(i);
                map.put("kwPkgIdList[" + i + "]", aLong);
            }
            localVarFormParams.putAll(map);
        }
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 广告组绑定关键词、行业类目词包、自定义/禁推词包
     *
     * @return AdsBatchReplicateResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsBatchReplicateResponse addGroupKw(AddGroupKwForm data) throws ApiException {
        ApiResponse<AdsBatchReplicateResponse> resp = addGroupKwHttpInfo(data);
        return resp.getData();
    }

    /**
     * 广告组绑定关键词、行业类目词包、自定义/禁推词包
     *
     * @return ApiResponse&lt;AdsBatchReplicateResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsBatchReplicateResponse> addGroupKwHttpInfo(AddGroupKwForm data)
            throws ApiException {
        com.squareup.okhttp.Call call = addGroupKwBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsBatchReplicateResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call addGroupKwBeforeCall(
            AddGroupKwForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                addGroupKwAddCall(data, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 广告组绑定关键词、行业类目词包、自定义/禁推词包--建立链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call addGroupKwAddCall(
            AddGroupKwForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = data;
        // create path and map variables
        String localVarPath = "/v3/communal/searchKeyWord/addGroupKw";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> map = new HashMap<>();
        List<AddGroupKwForm.CategoryPackage> categoryPackages = data.getCategoryPackages();
        if (!CollectionUtils.isEmpty(categoryPackages)) {
            for (int i = 0; i < categoryPackages.size(); i++) {
                String jsonStr = JSONObject.toJSONString(categoryPackages.get(i));
                Map<String, Object> maps = (Map<String, Object>) JSON.parse(jsonStr);
                JSONObject jsonObject = JSONObject.parseObject(jsonStr);
                Set<String> strings = jsonObject.keySet();
                for (String str : strings) {
                    map.put("categoryPackages[" + i + "]." + str, maps.get(str));
                }
            }
            localVarFormParams.putAll(map);
        }
        List<AddGroupKwForm.CustomOrNoPackage> customOrNoPackages = data.getCustomOrNoPackages();
        if (!CollectionUtils.isEmpty(customOrNoPackages)) {
            for (int i = 0; i < customOrNoPackages.size(); i++) {
                String jsonStr = JSONObject.toJSONString(customOrNoPackages.get(i));
                Map<String, Object> maps = (Map<String, Object>) JSON.parse(jsonStr);
                JSONObject jsonObject = JSONObject.parseObject(jsonStr);
                Set<String> strings = jsonObject.keySet();
                for (String str : strings) {
                    map.put("customOrNoPackages[" + i + "]." + str, maps.get(str));
                }
            }
            localVarFormParams.putAll(map);
        }
        List<AddGroupKwForm.SearchKeyword> searchKeywords = data.getSearchKeywords();
        if (!CollectionUtils.isEmpty(searchKeywords)) {
            for (int i = 0; i < searchKeywords.size(); i++) {
                String jsonStr = JSONObject.toJSONString(searchKeywords.get(i));
                Map<String, Object> maps = (Map<String, Object>) JSON.parse(jsonStr);
                JSONObject jsonObject = JSONObject.parseObject(jsonStr);
                Set<String> strings = jsonObject.keySet();
                for (String str : strings) {
                    map.put("searchKeywords[" + i + "]." + str, maps.get(str));
                }
            }
            localVarFormParams.putAll(map);
        }
        if (data.getAdGroupId() != null) {
            localVarFormParams.put("adGroupId", data.getAdGroupId());
        }
        if (data.getAppId() != null) {
            localVarFormParams.put("kwPackageType", data.getAppId());
        }

        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 广告组删除关键词、行业类目词包、自定义/禁推词包
     *
     * @return AdsBatchReplicateResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsBatchReplicateResponse delGroupKw(DeleteGroupKwForm data) throws ApiException {
        ApiResponse<AdsBatchReplicateResponse> resp = delGroupKwHttpInfo(data);
        return resp.getData();
    }

    /**
     * 广告组删除关键词、行业类目词包、自定义/禁推词包
     *
     * @return ApiResponse&lt;AdsBatchReplicateResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsBatchReplicateResponse> delGroupKwHttpInfo(DeleteGroupKwForm data)
            throws ApiException {
        com.squareup.okhttp.Call call = delGroupKwBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsBatchReplicateResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call delGroupKwBeforeCall(
            DeleteGroupKwForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                delGroupKwAddCall(data, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 广告组删除关键词、行业类目词包、自定义/禁推词包--建立链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call delGroupKwAddCall(
            DeleteGroupKwForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = data;
        // create path and map variables
        String localVarPath = "/v3/communal/searchKeyWord/deleteGroupKw";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> map = new HashMap<>();
        @Valid List<DeleteGroupKwForm.DeleteCategoryPackage> categoryPackages = data.getCategoryPackages();
        if (!CollectionUtils.isEmpty(categoryPackages)) {
            for (int i = 0; i < categoryPackages.size(); i++) {
                String jsonStr = JSONObject.toJSONString(categoryPackages.get(i));
                Map<String, Object> maps = (Map<String, Object>) JSON.parse(jsonStr);
                JSONObject jsonObject = JSONObject.parseObject(jsonStr);
                Set<String> strings = jsonObject.keySet();
                for (String str : strings) {
                    map.put("categoryPackages[" + i + "]." + str, maps.get(str));
                }
            }
            localVarFormParams.putAll(map);
        }
        @Valid List<DeleteGroupKwForm.DeleteCustomOrNoPackage> customOrNoPackages = data.getCustomOrNoPackages();

        if (!CollectionUtils.isEmpty(customOrNoPackages)) {
            for (int i = 0; i < customOrNoPackages.size(); i++) {
                String jsonStr = JSONObject.toJSONString(customOrNoPackages.get(i));
                Map<String, Object> maps = (Map<String, Object>) JSON.parse(jsonStr);
                JSONObject jsonObject = JSONObject.parseObject(jsonStr);
                Set<String> strings = jsonObject.keySet();
                for (String str : strings) {
                    map.put("customOrNoPackages[" + i + "]." + str, maps.get(str));
                }
            }
            localVarFormParams.putAll(map);
        }
        @Valid List<DeleteGroupKwForm.DeleteSearchKeyword> searchKeywords = data.getSearchKeywords();
        if (!CollectionUtils.isEmpty(searchKeywords)) {
            for (int i = 0; i < searchKeywords.size(); i++) {
                String jsonStr = JSONObject.toJSONString(searchKeywords.get(i));
                Map<String, Object> maps = (Map<String, Object>) JSON.parse(jsonStr);
                JSONObject jsonObject = JSONObject.parseObject(jsonStr);
                Set<String> strings = jsonObject.keySet();
                for (String str : strings) {
                    map.put("searchKeywords[" + i + "]." + str, maps.get(str));
                }
            }
            localVarFormParams.putAll(map);
        }
        if (data.getAdGroupId() != null) {
            localVarFormParams.put("adGroupId", data.getAdGroupId());
        }

        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 广告组编辑关键词、行业类目词包、自定义词包价格
     *
     * @return AdsBatchReplicateResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsBatchReplicateResponse editGroupKw(EditGroupKwForm data) throws ApiException {
        ApiResponse<AdsBatchReplicateResponse> resp = editGroupKwHttpInfo(data);
        return resp.getData();
    }

    /**
     * 广告组编辑关键词、行业类目词包、自定义词包价格
     *
     * @return ApiResponse&lt;AdsBatchReplicateResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsBatchReplicateResponse> editGroupKwHttpInfo(EditGroupKwForm data)
            throws ApiException {
        com.squareup.okhttp.Call call = editGroupKwBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsBatchReplicateResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call editGroupKwBeforeCall(
            EditGroupKwForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                editGroupKwAddCall(data, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 广告组编辑关键词、行业类目词包、自定义词包价格--建立链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call editGroupKwAddCall(
            EditGroupKwForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = data;
        // create path and map variables
        String localVarPath = "/v3/communal/searchKeyWord/editGroupKw";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> map = new HashMap<>();
        List<EditGroupKwForm.EditCustomPackage> customPackages = data.getCustomPackages();
        if (!CollectionUtils.isEmpty(customPackages)) {
            for (int i = 0; i < customPackages.size(); i++) {
                String jsonStr = JSONObject.toJSONString(customPackages.get(i));
                Map<String, Object> maps = (Map<String, Object>) JSON.parse(jsonStr);
                JSONObject jsonObject = JSONObject.parseObject(jsonStr);
                Set<String> strings = jsonObject.keySet();
                for (String str : strings) {
                    map.put("customPackages[" + i + "]." + str, maps.get(str));
                }
            }
            localVarFormParams.putAll(map);
        }
        List<EditGroupKwForm.EditCategoryPackage> category = data.getCategoryPackages();
        if (!CollectionUtils.isEmpty(category)) {
            for (int i = 0; i < category.size(); i++) {
                String jsonStr = JSONObject.toJSONString(category.get(i));
                Map<String, Object> maps = (Map<String, Object>) JSON.parse(jsonStr);
                JSONObject jsonObject = JSONObject.parseObject(jsonStr);
                Set<String> strings = jsonObject.keySet();
                for (String str : strings) {
                    map.put("categoryPackages[" + i + "]." + str, maps.get(str));
                }
            }
            localVarFormParams.putAll(map);
        }
        List<EditGroupKwForm.EditSearchKeyword> searchKeywords = data.getSearchKeywords();
        if (!CollectionUtils.isEmpty(searchKeywords)) {
            for (int i = 0; i < searchKeywords.size(); i++) {
                String jsonStr = JSONObject.toJSONString(searchKeywords.get(i));
                Map<String, Object> maps = (Map<String, Object>) JSON.parse(jsonStr);
                JSONObject jsonObject = JSONObject.parseObject(jsonStr);
                Set<String> strings = jsonObject.keySet();
                for (String str : strings) {
                    map.put("searchKeywords[" + i + "]." + str, maps.get(str));
                }
            }
            localVarFormParams.putAll(map);
        }
        if (data.getAdGroupId() != null) {
            localVarFormParams.put("adGroupId", data.getAdGroupId());
        }
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }


    /**
     * 根据packageId查询自定义词包里的词
     *
     * @return AdsQueryPackageDTOResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsQueryPackageDTOResponse queryByKwPackageId(PremiumCustomKwDTO data) throws ApiException {
        ApiResponse<AdsQueryPackageDTOResponse> resp = queryByKwPackageIdHttpInfo(data);
        return resp.getData();
    }

    /**
     * 根据packageId查询自定义词包里的词
     *
     * @return ApiResponse&lt;AdsQueryPackageDTOResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsQueryPackageDTOResponse> queryByKwPackageIdHttpInfo(PremiumCustomKwDTO data)
            throws ApiException {
        com.squareup.okhttp.Call call = queryByKwPackageIdBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsQueryPackageDTOResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryByKwPackageIdBeforeCall(
            PremiumCustomKwDTO data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                queryByKwPackageIdAddCall(data, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 广根据packageId查询自定义词包里的词--建立链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryByKwPackageIdAddCall(
            PremiumCustomKwDTO data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = data;
        // create path and map variables
        String localVarPath = "/v3/communal/searchKeyWord/queryKwByPackageId";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }
}
