package com.omni.ads.api;

import com.google.gson.reflect.TypeToken;
import com.omni.ads.baseconfig.*;
import com.omni.ads.model.adsdata.AdsDataResponse;
import com.omni.ads.model.adstarget.*;
import com.omni.ads.model.material.AdsMtForm;
import com.omni.ads.utils.JsonToMapUtils;
import com.omni.ads.utils.ThreadLocalUtil;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdsTargetApi {
    private ApiClient apiClient;

    public AdsTargetApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AdsTargetApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * 新增定向
     *
     * @return AdsAddTargetResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsAddTargetResponse addTarget(AdsTargetVo data) throws ApiException {
        ApiResponse<AdsAddTargetResponse> resp = addTargetHttpInfo(data);
        return resp.getData();
    }

    /**
     * 新增定向
     *
     * @return ApiResponse&lt;AdsAddTargetResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsAddTargetResponse> addTargetHttpInfo(AdsTargetVo data)
            throws ApiException {
        com.squareup.okhttp.Call call = addTargetBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsAddTargetResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call addTargetBeforeCall(
            AdsTargetVo data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                addTargetAddCall(data, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 新增定向建立链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call addTargetAddCall(
            AdsTargetVo data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = null;
        // create path and map variables
        String localVarPath = "/v2/communal/target/add";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }


    /**
     * 获取定向
     *
     * @return AdsAddTargetResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsAddTargetResponse getTarget(AdsTargetForm data) throws ApiException {
        ApiResponse<AdsAddTargetResponse> resp = getTargetHttpInfo(data);
        return resp.getData();
    }

    /**
     * 获取定向
     *
     * @return ApiResponse&lt;AdsAddTargetResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsAddTargetResponse> getTargetHttpInfo(AdsTargetForm data)
            throws ApiException {
        com.squareup.okhttp.Call call = getTargetBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsAddTargetResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTargetBeforeCall(
            AdsTargetForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                getTargetAddCall(data, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 获取定向建立链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTargetAddCall(
            AdsTargetForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = null;
        // create path and map variables
        String localVarPath = "/v2/communal/target/get";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (data.getId() != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("id", data.getId()));
        if (data.getOpenV2TargetId() != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("openV2TargetId", data.getOpenV2TargetId()));
        if (data.getBizType() != null)
            localVarQueryParams.addAll(
                    apiClient.parameterToPair("bizType", data.getBizType()));
        if (data.getDelStatus() != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("delStatus", data.getDelStatus()));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarFormParams.put("id", data.getId());
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "GET",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 删除定向
     *
     * @return AdsDelTargetResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsDelTargetResponse delTarget(AdsTargetForm data) throws ApiException {
        ApiResponse<AdsDelTargetResponse> resp = delTargetHttpInfo(data);
        return resp.getData();
    }

    /**
     * 删除定向
     *
     * @return ApiResponse&lt;AdsDelTargetResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsDelTargetResponse> delTargetHttpInfo(AdsTargetForm data)
            throws ApiException {
        com.squareup.okhttp.Call call = delTargetBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsDelTargetResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call delTargetBeforeCall(
            AdsTargetForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                delTargetAddCall(data, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 删除定向建立链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call delTargetAddCall(
            AdsTargetForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = null;
        // create path and map variables
        String localVarPath = "/v2/communal/target/del";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 修改定向
     *
     * @return AdsAddTargetResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsAddTargetResponse editTarget(AdsTargetVo data) throws ApiException {
        ApiResponse<AdsAddTargetResponse> resp = editTargetHttpInfo(data);
        return resp.getData();
    }

    /**
     * 修改定向
     *
     * @return ApiResponse&lt;AdsAddTargetResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsAddTargetResponse> editTargetHttpInfo(AdsTargetVo data)
            throws ApiException {
        com.squareup.okhttp.Call call = editTargetBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsAddTargetResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call editTargetBeforeCall(
            AdsTargetVo data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                editTargetAddCall(data, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 修改定向建立链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call editTargetAddCall(
            AdsTargetVo data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = null;
        // create path and map variables
        String localVarPath = "/v2/communal/target/update";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 获取定向列表
     *
     * @return AdsTargetListResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsTargetListResponse targetList(TargetFilterVo data) throws ApiException {
        ApiResponse<AdsTargetListResponse> resp = targetListHttpInfo(data);
        return resp.getData();
    }

    /**
     * 获取定向列表
     *
     * @return ApiResponse&lt;AdsTargetListResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsTargetListResponse> targetListHttpInfo(TargetFilterVo data)
            throws ApiException {
        com.squareup.okhttp.Call call = targetListBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsTargetListResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call targetListBeforeCall(
            TargetFilterVo data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                targetListAddCall(data, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 获取定向列表建立链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call targetListAddCall(
            TargetFilterVo data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = null;
        // create path and map variables
        String localVarPath = "/v2/communal/target/list";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 查询定向app元数据
     *
     * @return AdsQueryDataResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsQueryDataResponse queryData(Integer showType, Integer extensionType, Integer flowScene, boolean isTop) throws ApiException {
        ApiResponse<AdsQueryDataResponse> resp = queryDataHttpInfo(showType, extensionType, flowScene, isTop);
        return resp.getData();
    }

    /**
     * 查询定向app元数据
     *
     * @return ApiResponse&lt;AdsQueryDataResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsQueryDataResponse> queryDataHttpInfo(Integer showType, Integer extensionType, Integer flowScene, boolean isTop)
            throws ApiException {
        com.squareup.okhttp.Call call = queryDataBeforeCall(showType, extensionType, flowScene, isTop, null, null);
        Type localVarReturnType = new TypeToken<AdsQueryDataResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryDataBeforeCall(
            Integer showType, Integer extensionType, Integer flowScene, boolean isTop,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                queryDataAddCall(showType, extensionType, flowScene, isTop, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 查询定向app元数据建立链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryDataAddCall(
            Integer showType, Integer extensionType, Integer flowScene, boolean isTop,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = null;
        // create path and map variables
        String localVarPath = "/v2/communal/target/get/metadata/app/list";
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (showType != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("showType", showType));
        if (extensionType != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("extensionType", extensionType));
        if (flowScene != null)
            localVarQueryParams.addAll(
                    apiClient.parameterToPair("flowScene", flowScene));
        if (isTop == true)
            localVarQueryParams.addAll(
                    apiClient.parameterToPair("isTop", true));
        if (isTop == false)
            localVarQueryParams.addAll(
                    apiClient.parameterToPair("isTop", false));
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "GET",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 获取元数据
     *
     * @return AdsQueryDataResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsQueryDataResponse getMetadata(Integer showType, Integer extensionType, Integer flowScene) throws ApiException {
        ApiResponse<AdsQueryDataResponse> resp = getMetadataHttpInfo(showType, extensionType, flowScene);
        return resp.getData();
    }

    /**
     * 获取元数据
     *
     * @return ApiResponse&lt;AdsQueryDataResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsQueryDataResponse> getMetadataHttpInfo(Integer showType, Integer extensionType, Integer flowScene)
            throws ApiException {
        com.squareup.okhttp.Call call = getMetadataBeforeCall(showType, extensionType, flowScene, null, null);
        Type localVarReturnType = new TypeToken<AdsQueryDataResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getMetadataBeforeCall(
            Integer showType, Integer extensionType, Integer flowScene,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                getMetadataAddCall(showType, extensionType, flowScene, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 获取元数据建立链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getMetadataAddCall(
            Integer showType, Integer extensionType, Integer flowScene,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = null;
        // create path and map variables
        String localVarPath = "/v2/communal/target/get/metadata";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (showType != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("showType", showType));
        if (extensionType != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("extensionType", extensionType));
        if (flowScene != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("flowTcene", flowScene));
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "GET",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 获取定向联盟APP元数据
     *
     * @return AdsAppMetadataResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsAppMetadataResponse getAppMetadata(AdsUAppQueryForm data) throws ApiException {
        ApiResponse<AdsAppMetadataResponse> resp = getAppMetadataHttpInfo(data);
        return resp.getData();
    }

    /**
     * 获取定向联盟APP元数据
     *
     * @return ApiResponse&lt;AdsAppMetadataResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsAppMetadataResponse> getAppMetadataHttpInfo(AdsUAppQueryForm data)
            throws ApiException {
        com.squareup.okhttp.Call call = getAppMetadataBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsAppMetadataResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAppMetadataBeforeCall(
            AdsUAppQueryForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                getAppMetadataAddCall(data, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 获取定向联盟APP元数据建立链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAppMetadataAddCall(
            AdsUAppQueryForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = data;
        // create path and map variables
        String localVarPath = "/v2/communal/target/get/metadata/newUapp/list";
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (data.getAppIds() != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("app_ids", data.getAppIds()));
        if (data.getAppName() != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("app_name", data.getAppName()));
        if (data.getExtensionType() != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("extension_type", data.getExtensionType()));
        if (data.getFlowScene() != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("flow_scene", data.getFlowScene()));
        if (data.getMediaPlatform() != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("media_platform", data.getMediaPlatform()));
        if (data.getPage() != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("page", data.getPage()));
        if (data.getRows() != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("rows", data.getRows()));
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "GET",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 用戶兴趣标签
     *
     * @return AdsGetTagsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsGetTagsResponse gettags(Integer showType, Integer extensionType, Integer flowScene) throws ApiException {
        ApiResponse<AdsGetTagsResponse> resp = gettagsHttpInfo(showType, extensionType, flowScene);
        return resp.getData();
    }

    /**
     * 用戶兴趣标签
     *
     * @return ApiResponse&lt;AdsGetTagsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsGetTagsResponse> gettagsHttpInfo(Integer showType, Integer extensionType, Integer flowScene)
            throws ApiException {
        com.squareup.okhttp.Call call = gettagsBeforeCall(showType, extensionType, flowScene, null, null);
        Type localVarReturnType = new TypeToken<AdsGetTagsResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call gettagsBeforeCall(
            Integer showType, Integer extensionType, Integer flowScene,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                gettagsAddCall(showType, extensionType, flowScene, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 用戶兴趣标签建立链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call gettagsAddCall(
            Integer showType, Integer extensionType, Integer flowScene,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = null;
        // create path and map variables
        String localVarPath = "/v2/communal/target/get/metadata/userInterestTagV2";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (showType != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("showType", showType));
        if (extensionType != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("extensionType", extensionType));
        if (flowScene != null)
            localVarQueryParams.addAll(
                    apiClient.parameterToPair("flowScene", flowScene));
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "GET",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * IMEI上传
     *
     * @return AdsDataResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsDataResponse imeiUpload(AdsTargetImeiForm form) throws ApiException {
        ApiResponse<AdsDataResponse> resp = imeiUploadHttpInfo(form);
        return resp.getData();
    }

    /**
     * IMEI上传
     *
     * @param form (required)
     * @return ApiResponse&lt;AdsDataResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsDataResponse> imeiUploadHttpInfo(AdsTargetImeiForm form)
            throws ApiException {
        com.squareup.okhttp.Call call = imeiUploadBeforeCall(form, null, null);
        Type localVarReturnType = new TypeToken<AdsDataResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call imeiUploadBeforeCall(
            AdsTargetImeiForm form,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        if (form == null) {
            throw new ApiException(
                    "Missing the required parameter 'data' ");
        }
        com.squareup.okhttp.Call call =
                imeiUploadAddCall(form, progressListener, progressRequestListener);
        return call;
    }

    /**
     * 建立对IMEI上传 的连接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call imeiUploadAddCall(
            AdsTargetImeiForm form,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = form;
        String localVarPath = "/v2/communal/target/imei/upload";
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> formMap = JsonToMapUtils.getForm(form);
        localVarFormParams.putAll(formMap);
        final String[] localVarAccepts = {"multipart/form-data"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        localVarHeaderParams.put("Content-Type", "multipart/form-data");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }

    /**
     * 运算人群包
     *
     * @return AdsDataResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public AdsDataResponse addExpansionTask(AdsTargetTaskForm data) throws ApiException {
        ApiResponse<AdsDataResponse> resp = addExpansionTaskHttpInfo(data);
        return resp.getData();
    }

    /**
     * 运算人群包
     *
     * @return ApiResponse&lt;AdsDataResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ApiResponse<AdsDataResponse> addExpansionTaskHttpInfo(AdsTargetTaskForm data)
            throws ApiException {
        com.squareup.okhttp.Call call = addExpansionTaskBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<AdsDataResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call addExpansionTaskBeforeCall(
            AdsTargetTaskForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {

        com.squareup.okhttp.Call call =
                addExpansionTaskAddCall(data, progressListener, progressRequestListener);
        return call;
    }


    /**
     * 获取运算人群包链接
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call addExpansionTaskAddCall(
            AdsTargetTaskForm data,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener)
            throws ApiException {
        Object localVarPostBody = null;
        // create path and map variables
        String localVarPath = "/v2/communal/target/addExpansionTask";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> form = JsonToMapUtils.getForm(data);
        localVarFormParams.putAll(form);
        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", "*/*");
        final String[] localVarContentTypes = {"application/json", "application/xml"};
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Authorization", ThreadLocalUtil.threadLocal.get().getToken());
        localVarHeaderParams.put("Accept-Encoding", "gzip,deflate,br");
        localVarHeaderParams.put("Connection", "keep-alive");
        if (progressListener != null) {
            apiClient
                    .getHttpClient()
                    .networkInterceptors()
                    .add(
                            new com.squareup.okhttp.Interceptor() {
                                @Override
                                public com.squareup.okhttp.Response intercept(
                                        Chain chain) throws IOException {
                                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                                    return originalResponse
                                            .newBuilder()
                                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                                            .build();
                                }
                            });
        }

        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return apiClient.buildCall(
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarFormParams,
                localVarAuthNames,
                progressRequestListener);
    }


}
