package com.omni.ads.baseconfig;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.internal.Util;
import okio.BufferedSink;
import okio.ByteString;
import okio.Okio;
import okio.Source;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public class AdsRequestBody extends RequestBody {

    @Override
    public MediaType contentType() {
        return null;
    }

    @Override
    public void writeTo(BufferedSink bufferedSink) throws IOException {

    }

    public static RequestBody createNew(MediaType contentType, String content) {
        Charset charset = Util.UTF_8;
        if (contentType != null) {
            charset = contentType.charset();
            if (charset == null) {
                charset = Util.UTF_8;
                contentType = MediaType.parse(String.valueOf(contentType));
            }
        }

        byte[] bytes = content.getBytes(charset);
        return createNew(contentType, bytes);
    }

    public static RequestBody createNew(final MediaType contentType, final ByteString content) {
        return new RequestBody() {
            public MediaType contentType() {
                return contentType;
            }

            public long contentLength() throws IOException {
                return (long)content.size();
            }

            public void writeTo(BufferedSink sink) throws IOException {
                sink.write(content);
            }
        };
    }

    public static RequestBody createNew(MediaType contentType, byte[] content) {
        return create(contentType, content, 0, content.length);
    }

    public static RequestBody create(final MediaType contentType, final byte[] content, final int offset, final int byteCount) {
        if (content == null) {
            throw new NullPointerException("content == null");
        } else {
            Util.checkOffsetAndCount((long)content.length, (long)offset, (long)byteCount);
            return new RequestBody() {
                public MediaType contentType() {
                    return contentType;
                }

                public long contentLength() {
                    return (long)byteCount;
                }

                public void writeTo(BufferedSink sink) throws IOException {
                    sink.write(content, offset, byteCount);
                }
            };
        }
    }

    public static RequestBody create(final MediaType contentType, final File file) {
        if (file == null) {
            throw new NullPointerException("content == null");
        } else {
            return new RequestBody() {
                public MediaType contentType() {
                    return contentType;
                }

                public long contentLength() {
                    return file.length();
                }

                public void writeTo(BufferedSink sink) throws IOException {
                    Source source = null;

                    try {
                        source = Okio.source(file);
                        sink.writeAll(source);
                    } finally {
                        Util.closeQuietly(source);
                    }

                }
            };
        }
    }
}
