package com.omni.ads.baseconfig;

import com.omni.ads.auth.ApiKeyAuth;
import com.omni.ads.utils.ThreadLocalUtil;
import com.omni.ads.utils.TokenUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * @author: Lex
 * @create: 2024/5/20
 */
public class OmniAds extends App {
    public static final int ONE_MINUTE = 60000;
    private ApiClient defaultApiClient = Configuration.getDefaultApiClient();

    private String basePath = "http://sapi-ads-test.wanyol.com";

    private long timestamp;

    private String token;

    private final Long ownerId;

    private final String apiId;

    private final String apiKey;

    private final OmniAdsHolder holder;

    /**
     * 获取本地线程缓存的OmniAds对象。
     *
     * @param ownerId
     * @param apiId
     * @param apiKey
     * @return
     */
    public static OmniAds getInstance(Long ownerId, String apiId, String apiKey) {
        OmniAds omniAds = ThreadLocalUtil.getOmniApi();
        if (omniAds != null) {
            OmniAdsHolder holder = new OmniAdsHolder(ownerId, apiId, apiKey);
            if (omniAds.holder.equals(holder)) {
                return omniAds;
            }
        }
        return new OmniAds(ownerId, apiId, apiKey);
    }

    public OmniAds(Long ownerId, String apiId, String apiKey) {
        this.ownerId = ownerId;
        this.apiId = apiId;
        this.apiKey = apiKey;
        this.holder = new OmniAdsHolder(ownerId, apiId, apiKey);
        //传递token
        ThreadLocalUtil.setOmniApi(this);
    }

    public void generateToken() {
        long newTs = System.currentTimeMillis();
        if (timestamp + ONE_MINUTE < newTs) {
            this.timestamp = newTs;
            this.token = TokenUtils.getToken(ownerId, apiId, apiKey);
        }
    }

    public OmniAds setDebug(boolean isDebug) {
        defaultApiClient.initAuthentications();
        defaultApiClient.setDebugging(isDebug);
        return this;
    }

    public String getToken() {
        generateToken();
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setApiClient(ApiClient apiClient) {
        defaultApiClient = apiClient;
    }

    public String getBasePath() {
        return basePath;
    }

    public void setHost(String host) {
        defaultApiClient.setBasePath(host);
    }

    public void useSandbox() {
        basePath = "http://sapi-ads-test.wanyol.com";
        this.setHost(basePath);
    }

    public void useProduction() {
        basePath = "https://sapi.ads.heytapmobi.com";
        this.setHost(basePath);
    }

    public void setIpPort(String ip, int port, boolean useHttps) {
        if (useHttps) {
            basePath = "https://" + ip + ":" + port;
        } else {
            basePath = "http://" + ip + ":" + port;
        }
        this.setHost(basePath);
        Map<String, String> monitorHeader = new HashMap<>();
        monitorHeader.put("Host", "sapi-ads-test.wanyol.com");
        setHeader(monitorHeader);
    }

    public void setHeader(Map<String, String> headerMap) {
        if (headerMap == null) {
            return;
        }
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            defaultApiClient.addDefaultHeader(entry.getKey(), entry.getValue());
        }
    }

    public void setAccessToken(String accessTokenValue) {
        ApiKeyAuth accessToken = (ApiKeyAuth) defaultApiClient.getAuthentication("accessToken");
        accessToken.setApiKey(accessTokenValue);
    }

    /**
     * 单位毫秒ms
     *
     * @param timeout
     */
    public void setConnectTimeout(int timeout) {
        defaultApiClient.setConnectTimeout(timeout);
    }

    /**
     * 单位毫秒ms
     *
     * @param readTimeout
     */
    public void setReadTimeout(int readTimeout) {
        defaultApiClient.setReadTimeout(readTimeout);
    }

    /**
     * 单位毫秒ms
     *
     * @param writeTimeout
     */
    public void setWriteTimeout(int writeTimeout) {
        defaultApiClient.setWriteTimeout(writeTimeout);
    }

}
