package com.omni.ads.baseconfig;

import java.util.Objects;

/**
 * @author: 80350606
 * @create: 2024/5/21
 */
public class OmniAdsHolder {

    private final Long ownerId;

    private final String apiId;

    private final String apiKey;

    public OmniAdsHolder(Long ownerId, String apiId, String apiKey) {
        this.ownerId = ownerId;
        this.apiId = apiId;
        this.apiKey = apiKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OmniAdsHolder that = (OmniAdsHolder) o;
        return Objects.equals(ownerId, that.ownerId) && Objects.equals(apiId, that.apiId) && Objects.equals(apiKey, that.apiKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ownerId, apiId, apiKey);
    }

}
