package com.omni.ads.container;

import com.google.inject.Inject;
import com.omni.ads.baseconfig.ApiException;
import com.omni.ads.baseconfig.Constant;
import com.omni.ads.baseconfig.ResultDto;
import com.omni.ads.api.AdsAgencyApi;
import com.omni.ads.exception.OmniAdsResponseException;
import com.omni.ads.model.adsagency.*;
import com.omni.ads.model.adsauth.AdsBaseForm;
import com.omni.ads.model.adsauth.AdsOwnerMenuInfo;
import com.omni.ads.model.adscommunal.Pagination;
import com.omni.ads.model.adsowner.AdsOwnerVo;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;

import javax.validation.constraints.NotNull;

public class AdsAgencyContainer {
    @Inject
    AdsAgencyApi api;
    private static final Logger LOGGER = LoggerFactory.getLogger(AdsAgencyContainer.class);

    /**
     * （代理商+管理员权限运营）
     * <p>
     * 查询所有子客户和次级代理商
     *
     * @param data
     * @return
     * @api
     */
    @ApiOperation(value = "代理商客户查询", notes = "查询所有子客户和次级代理商", httpMethod = "POST", consumes = MediaType.APPLICATION_FORM_URLENCODED_VALUE)
    public ResultDto<Pagination<AdsOwnerBalanceVo>> v2AgencyCustomerList(CustomerListReq data) throws ApiException, OmniAdsResponseException {
        ResultDto<Pagination<AdsOwnerBalanceVo>> rt = new ResultDto<>();
        try {
            AdsQueryAllCustomerInfoResponse response = api.queryAllCustomer(data);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2AgencyCustomerList exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 查询广告主对应的菜单、数据权限信息
     * loginType 只能为 1 2 3 4， 且为必传参数
     * 如果代理商查询子客户，需要传子客户ownerId
     *
     * @param form form.ownerId 和 form.loginType 不能同时为空
     * @return
     * @api
     */
    public ResultDto<AdsOwnerMenuInfo> v2CommunalAuthQuery(AdsBaseForm form) throws ApiException, OmniAdsResponseException {
        ResultDto<AdsOwnerMenuInfo> rt = new ResultDto<>();
        try {
            AdsQueryMenuResponse response = api.queryAdMenu(form);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2AgencyCustomerList exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }

    }

    /**
     * 账务流水
     *
     * @param billHisForm 账务流水查询条件
     * @param page        当前页
     * @param pageCount   一页个数
     * @param loginType   登陆类型
     * @return
     * @throws Exception
     * @api
     */
    public ResultDto<Pagination<AdsAccBillHisVo>> v2FinanceBillHis(AdsAccBillHisForm billHisForm, @NotNull Integer page, @NotNull Integer pageCount, @NotNull Integer loginType) throws ApiException, OmniAdsResponseException {
        ResultDto<Pagination<AdsAccBillHisVo>> rt = new ResultDto<>();
        try {
            AdsQueryBillsResponse response = api.queryBills(billHisForm, page, pageCount, loginType);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2FinanceBillHis exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 子客户余额查询
     */
    public ResultDto<AdsBalanceVo> v2OwnerBalance() throws ApiException, OmniAdsResponseException {
        ResultDto<AdsBalanceVo> rt = new ResultDto<>();
        try {
            AdsQueryBalanceResponse response = api.queryOwnerBalance();
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2OwnerBalance exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 代理商账务情况 - 包含总余额,各个子账户余额以及预算
     * <p>
     * 代理商、以及具备管理权权限的运营调用
     *
     * @return
     * @api
     */
    public ResultDto<AdsBalanceVo> v2AgencyBalance() throws ApiException, OmniAdsResponseException {
        ResultDto<AdsBalanceVo> rt = new ResultDto<>();
        try {
            AdsQueryBalanceResponse response = api.queryAgencyBalance();
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2AgencyBalance exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 代理商基础信息接口
     *
     * @return
     * @api
     */
    public ResultDto<AdsOwnerVo> v2AgencyInfo() {
        ResultDto<AdsOwnerVo> rt = new ResultDto<>();
        try {
            AdsQueryAgencyInfoResponse response = api.queryAgencyInfo();
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2AgencyInfo exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }
    /**
     * 财务流水导出
     * */
    public ResultDto<Void> v2FinanceBillHisExport(@NotNull AdsAccBillHisForm billHisForm, @NotNull Integer loginType)throws Exception{
        ResultDto<Void> rt = new ResultDto<>();
        try {
            AdsBillsExportResponse response = api.billHisForm(billHisForm, loginType);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2FinanceBillHisExport exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }
}


