package com.omni.ads.container;

import com.google.inject.Inject;
import com.omni.ads.baseconfig.ApiContainer;
import com.omni.ads.baseconfig.ApiException;
import com.omni.ads.baseconfig.Constant;
import com.omni.ads.baseconfig.ResultDto;
import com.omni.ads.api.AdsBidConfigApi;
import com.omni.ads.exception.OmniAdsResponseException;
import com.omni.ads.model.adsbidconfig.AdsAdGroupPriceConfigBo;
import com.omni.ads.model.adsbidconfig.AdsGetGroupPriceResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestParam;

public class AdsBidConfigApiContainer extends ApiContainer {
    @Inject
    AdsBidConfigApi api;

    private static final Logger LOGGER = LoggerFactory.getLogger(AdsBidConfigApiContainer.class);

    /**
     * 查询出价配置
     *
     * @param showType      显示类型
     * @param extensionType 扩展类型
     * @return HttpResponse<AdsAdGroupPriceConfigBo>
     * @api
     */
    public ResultDto<AdsAdGroupPriceConfigBo> v2CommunalIntervalConfigGroupPrice(@RequestParam("showType") Integer showType, @RequestParam("extensionType") Integer extensionType) throws ApiException, OmniAdsResponseException {
        ResultDto<AdsAdGroupPriceConfigBo> rt = new ResultDto<>();
        try {
            AdsGetGroupPriceResponse resp = api.getGroupPrice(showType, extensionType);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalIntervalConfigGroupPrice exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }
}

