package com.omni.ads.container;

import com.google.inject.Inject;
import com.omni.ads.baseconfig.ApiContainer;
import com.omni.ads.baseconfig.ApiException;
import com.omni.ads.baseconfig.Constant;
import com.omni.ads.baseconfig.ResultDto;
import com.omni.ads.api.AdsCommunalApi;
import com.omni.ads.model.adscommunal.*;
import com.omni.ads.model.adscreativity.vo.Groups;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * 【融合投放3.0】元数据配置查询
 * */
public class AdsCommunalApiContainer extends ApiContainer {
    @Inject
    AdsCommunalApi api;
    private static final Logger LOGGER = LoggerFactory.getLogger(AdsCommunalApiContainer.class);
    /**
     * 根据配置类型获取配置项
     * @param req 请求对象
     * @return 响应消息
     */
    public ResultDto<List<AdsConfigResp>> v3CommunalConfigGetList(@Validated() @ModelAttribute AdsConfigReq req) throws ApiException {
        ResultDto<List<AdsConfigResp>> rt = new ResultDto<>();
        try {
            AdsCommunalResponse response = api.configList(req);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3CommunalConfigGetList exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 根据配置类型批量获取配置项
     * @param req 请求对象
     * @return 响应消息
     */
    public ResultDto<Map<String, List<AdsConfigResp>>> v3CommunalConfigGetMap(@Validated() @ModelAttribute AdsConfigReq req){
        ResultDto<Map<String, List<AdsConfigResp>>> rt = new ResultDto<>();
        try {
            AdsCommunalGetMapResponse response = api.configGetMap(req);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3CommunalConfigGetMap exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 获取应用信息
     * */
    public ResultDto<AdsCommunalAppVo> v2CommunalAppInfo(@RequestParam(value = "appId", required = false) @ApiParam(value = "应用id", required = true) Integer appId,
                                                              @RequestParam(value = "pkgName", required = false) @ApiParam(value = "应用包名") String pkgName,
                                                              @RequestParam(value = "bizType", required = false) @ApiParam(value = "业务类型 1：cpd广告产品，2：feeds广告，3：合约广告，" +
                                                                      "4：招商活动广告，5：智能短信广告，6：联盟广告，7：搜索，100：外部ADX，101：业务公共类型，102：融合，201：电商", hidden = true) Integer bizType,
                                                              @RequestParam(value = "flowScene", required = false) @ApiParam(value = "流量场景：1-全流量场景，2-精选推广，3-安装有礼，4-开机必备，" +
                                                                      "5-搜索，6-信息流，7-Banner，8-开屏，9-插屏，10-原生，11-激励视频，12-联盟通投", hidden = true) Integer flowScene) throws ApiException {

        ResultDto<AdsCommunalAppVo> rt = new ResultDto<>();
        try {
            AdsCommunalGetAppInfoResponse response = api.getAppInfo(appId, pkgName, bizType, flowScene);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalGroupAppInfo exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 获取应用列表信息
     * */
    public ResultDto<List<AdsCommunalAppVo>> v2CommunalAppInfoList(AdsAppBatchSearchForm adsAppBatchSearchForm)  throws ApiException{
        ResultDto<List<AdsCommunalAppVo>> rt = new ResultDto<>();
        try {
            AdsCommunalAppListResponse response = api.getAppInfoList(adsAppBatchSearchForm);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalGroupAppInfoList exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }

    }

    /**
     * 获取有效动态词通配符
     *
     * @param req 请求参数
     * @return 返回值
     * @api
     */
    public ResultDto<Pagination<DynamicSymbolResp>> v2CommunalDynamicSymbolList(DynamicSymbolReq req) throws ApiException{
        ResultDto<Pagination<DynamicSymbolResp>> rt = new ResultDto<>();
        try {
            AdsCommunalSymbolResponse response = api.getSymbolList(req);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalDynamicSymbolList exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 查询建站落地页
     *
     * @param form
     * @return
     * @api
     * @tag 落地页相关
     */
    public ResultDto<List<AdsAdPageVo>> v2CommunalAdSparkPageNewList(AdsAdPageForm form) throws ApiException{
        ResultDto<List<AdsAdPageVo>> rt = new ResultDto<>();
        try {
            AdsCommunalSparkPageResponse response = api.getSparkPage(form);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalAdSparkPageNewList exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 查询规格列表
     * 根据条件查询获取规格列表
     *
     * @param param 规格查询条件
     * @return 满足条件的规格列表
     * @api
     * @tag 规格相关
     */
    public ResultDto<List<AdsV3MtrSpecVo>> v3CommunalSpecList(@Validated(Groups.Query.class) AdsV3MtrSpecForm param) throws ApiException{
        ResultDto<List<AdsV3MtrSpecVo>> rt = new ResultDto<>();
        try {
            AdsCommunalSpecResponse response = api.getSpec(param);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3CommunalSpecList exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 获取出价配置，出价方式及限定范围查询
     * */
    public ResultDto<AdsGroupPriceConfigBo> v3GroupPrice(@RequestParam(value = "flowScene", required = false)
                                                         @ApiParam(value = "流量场景：1-全流量场景，2-精选推广，3-安装有礼，4-开机必备，5-搜索，" +
                                                                 "6-信息流，7-Banner，8-开屏，9-插屏，10-原生，11-激励视频，12-联盟通投", required = true) Integer flowScene,
                                                         @RequestParam(value = "ocpcType", required = false)
                                                         @ApiParam(value = "目标转化类型，0-默认, 1-APP下载, 2-APP拉活, 4-游戏注册, 5-游戏付费, 6-表单注册, 7-注册, 8-回传激活, " +
                                                                 "9-应用付费, 10-回传留存, 11-应用内自定义转化, 12-应用内授信, 13-应用内下单, 14-deepLink拉活, 15-系统留存, 16-deeplink回传激活, " +
                                                                 "17-deeplink回传注册, 18-deeplink应用付费, 19-deeplink应用内自定义转化, 20-deeplink应用内授信, 21-deeplink应用内下单, " +
                                                                 "22-快应用付费, 23-游戏付费ROI1", required = true) Integer ocpcType,
                                                         @RequestParam(value = "extensionType", required = false)
                                                         @ApiParam(value = "推广目的 1：链接推广 2：应用推广 3: 快应用推广", required = true) Integer extensionType) throws ApiException{
        ResultDto<AdsGroupPriceConfigBo> rt = new ResultDto<>();
        try {
            AdsGroupPriceResponse response = api.getPrice(flowScene, ocpcType, extensionType);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3GroupPrice exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }

    }


}

