package com.omni.ads.container;

import com.google.gson.JsonSyntaxException;
import com.google.inject.Inject;
import com.omni.ads.api.AdsDataApi;
import com.omni.ads.baseconfig.ApiException;
import com.omni.ads.baseconfig.Constant;
import com.omni.ads.baseconfig.ResultDto;
import com.omni.ads.exception.OmniAdsResponseException;
import com.omni.ads.model.adsdata.AdsDataResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Map;
public class AdsDataApiContainer {
    @Inject
    AdsDataApi api;
    private static final Logger LOGGER = LoggerFactory.getLogger(AdsDataApiContainer.class);
    /**
     * 广告汇总数据查询-子客户
     */
    public ResultDto<Map<String, Object>> v3SummaryQueryAdData(Map<String, Object> map) throws ApiException, OmniAdsResponseException {
        ResultDto<Map<String, Object>> rt = new ResultDto<>();
        try {
            AdsDataResponse resp = api.getAdData(map);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3SummaryQueryAdData exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        } catch (JsonSyntaxException e1) {
            return rt;
        }
    }
    /**
     * 广告明细数据总量查询-子客户
     */

    public ResultDto<Map<String, Object>> v3TotalQueryAdData(Map<String, Object> map) throws ApiException, OmniAdsResponseException {
        ResultDto<Map<String, Object>> rt = new ResultDto<>();
        try {
            AdsDataResponse resp = api.getTotalData(map);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3TotalQueryAdData exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        } catch (JsonSyntaxException e1) {
            return rt;
        }
    }
    /**
     * 广告明细数据查询-子客户
     */
    public ResultDto<Map<String, Object>> v3QueryQueryAdData(Map<String, Object> map) throws ApiException, OmniAdsResponseException {
        ResultDto<Map<String, Object>> rt = new ResultDto<>();
        try {
            AdsDataResponse resp = api.getQueryData(map);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3QueryQueryAdData exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        } catch (JsonSyntaxException e1) {
            return rt;
        }
    }

    /**
     * 小游戏明细数据总量查询-子客户
     */
    public ResultDto<Map<String, Object>> v3TotalQueryQuickGame(Map<String, Object> map) throws ApiException, OmniAdsResponseException {
        ResultDto<Map<String, Object>> rt = new ResultDto<>();
        try {
            AdsDataResponse resp = api.getQuickGame(map);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3TotalQueryQuickGame exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        } catch (JsonSyntaxException e1) {
            return rt;
        }
    }

    /**
     * 小游戏明细数据查询-子客户
     */
    public ResultDto<Map<String, Object>> v3QueryQueryQuickGame(Map<String, Object> map) throws ApiException, OmniAdsResponseException {
        ResultDto<Map<String, Object>> rt = new ResultDto<>();
        try {
            AdsDataResponse resp = api.getQueryQueryQuickGame(map);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3QueryQueryQuickGame exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        } catch (JsonSyntaxException e1) {
            return rt;
        }
    }

    /**
     * 游戏实时明细数据总量查询-子客户
     */
    public ResultDto<Map<String, Object>> v3TotalQueryGameRTData(Map<String, Object> map) throws ApiException, OmniAdsResponseException {
        ResultDto<Map<String, Object>> rt = new ResultDto<>();
        try {
            AdsDataResponse resp = api.getRTData(map);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3TotalQueryGameRTData exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        } catch (JsonSyntaxException e1) {
            return rt;
        }
    }

    /**
     * 游戏实时明细数据查询-子客户
     */
    public ResultDto<Map<String, Object>> v3QueryQueryGameRTData(Map<String, Object> map) throws ApiException, OmniAdsResponseException {
        ResultDto<Map<String, Object>> rt = new ResultDto<>();
        try {
            AdsDataResponse resp = api.getQueryGameRTData(map);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3QueryQueryGameRTData exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        } catch (JsonSyntaxException e1) {
            return rt;
        }
    }

    /**
     * 游戏实时汇总数据查询-子客户
     */
    public ResultDto<Map<String, Object>> v3SummaryQueryGameRTData(Map<String, Object> map) throws ApiException, OmniAdsResponseException {
        ResultDto<Map<String, Object>> rt = new ResultDto<>();
        try {
            AdsDataResponse resp = api.getSummaryQueryGameRTData(map);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3SummaryQueryGameRTData exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        } catch (JsonSyntaxException e1) {
            return rt;
        }
    }

    /**
     * 游戏明细数据总量查询-子客户
     */

    public ResultDto<Map<String, Object>> v3TotalQueryGameOffLineData(Map<String, Object> map) throws ApiException, OmniAdsResponseException {
        ResultDto<Map<String, Object>> rt = new ResultDto<>();
        try {
            AdsDataResponse resp = api.getOffLineData(map);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3TotalQueryGameOffLineData exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        } catch (JsonSyntaxException e1) {
            return rt;
        }
    }

    /**
     * 游戏明细数据查询-子客户
     */
    public ResultDto<Map<String, Object>> v3QueryQueryGameOffLineData(Map<String, Object> map) throws ApiException, OmniAdsResponseException {
        ResultDto<Map<String, Object>> rt = new ResultDto<>();
        try {
            AdsDataResponse resp = api.getQueryGameData(map);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3QueryQueryGameOffLineData exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        } catch (JsonSyntaxException e1) {
            return rt;
        }
    }

    /**
     * 关键词明细数据总量查询-子客户
     */
    public ResultDto<Map<String, Object>> v3TotalQueryKwData(Map<String, Object> map) throws ApiException, OmniAdsResponseException {
        ResultDto<Map<String, Object>> rt = new ResultDto<>();
        try {
            AdsDataResponse resp = api.getTotalKwData(map);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3TotalQueryKwData exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        } catch (JsonSyntaxException e1) {
            return rt;
        }
    }

    /**
     * 关键词明细数据查询-子客户
     */
    public ResultDto<Map<String, Object>> v3QueryQueryKwData(Map<String, Object> map) throws ApiException, OmniAdsResponseException {
        ResultDto<Map<String, Object>> rt = new ResultDto<>();
        try {
            AdsDataResponse resp = api.getQueryKwData(map);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3QueryQueryKwData exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        } catch (JsonSyntaxException e1) {
            return rt;
        }
    }

    /**
     * 关键词汇总数据查询-子客户
     */
    public ResultDto<Map<String, Object>> v3SummaryQueryKwData(Map<String, Object> map) throws ApiException, OmniAdsResponseException {
        ResultDto<Map<String, Object>> rt = new ResultDto<>();
        try {
            AdsDataResponse resp = api.getSummaryQueryKwData(map);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3SummaryQueryKwData exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        } catch (JsonSyntaxException e1) {
            return rt;
        }
    }

    /**
     * 代理商消耗数据总量查询
     */
    public ResultDto<Map<String, Object>> v3AgencyTotalQueryOwnerCost(Map<String, Object> map) throws ApiException, OmniAdsResponseException {
        ResultDto<Map<String, Object>> rt = new ResultDto<>();
        try {
            AdsDataResponse resp = api.getAgencyCost(map);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3SummaryQueryKwData exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        } catch (JsonSyntaxException e1) {
            return rt;
        }
    }

    /**
     * 代理商消耗数据查询
     */
    public ResultDto<Map<String, Object>> v3AgencyQueryQueryOwnerCost(Map<String, Object> map) throws ApiException, OmniAdsResponseException {
        ResultDto<Map<String, Object>> rt = new ResultDto<>();
        try {
            AdsDataResponse resp = api.getAgencyQueryCost(map);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3AgencyQueryQueryOwnerCost exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        } catch (JsonSyntaxException e1) {
            return rt;
        }
    }

    /**
     * 代理商效果数据总量查询
     */
    public ResultDto<Map<String, Object>> v3AgencyTotalQueryAgencyEffect(Map<String, Object> map) throws ApiException, OmniAdsResponseException {
        ResultDto<Map<String, Object>> rt = new ResultDto<>();
        try {
            AdsDataResponse resp = api.getEffect(map);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3AgencyTotalQueryAgencyEffect exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        } catch (JsonSyntaxException e1) {
            return rt;
        }
    }

    /**
     * 代理商效果数据查询
     */
    public ResultDto<Map<String, Object>> v3AgencyQueryQueryAgencyEffect(Map<String, Object> map) throws ApiException, OmniAdsResponseException {
        ResultDto<Map<String, Object>> rt = new ResultDto<>();
        try {
            AdsDataResponse resp = api.getQueryEffect(map);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3AgencyTotalQueryAgencyEffect exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        } catch (JsonSyntaxException e1) {
            return rt;
        }
    }

    /**
     * 小游戏明细数据查询-代理商
     */

    public ResultDto<Map<String, Object>> v3AgencyQueryQueryAgentQuickGame(Map<String, Object> map) throws ApiException, OmniAdsResponseException {
        ResultDto<Map<String, Object>> rt = new ResultDto<>();
        try {
            AdsDataResponse resp = api.getQueryAgentQuickGame(map);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3AgencyQueryQueryAgentQuickGame exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        } catch (JsonSyntaxException e1) {
            return rt;
        }
    }

    /**
     * 子客户消耗数据查询
     */

    public ResultDto<Map<String, Object>> v3OmniapiQueryQueryOwnerCost(Map<String, Object> map) throws ApiException, OmniAdsResponseException {
        ResultDto<Map<String, Object>> rt = new ResultDto<>();
        try {
            AdsDataResponse resp = api.getOmniapiCost(map);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3AgencyQueryQueryAgentQuickGame exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        } catch (JsonSyntaxException e1) {
            return rt;
        }
    }

}
