package com.omni.ads.container;

import com.google.inject.Inject;
import com.omni.ads.baseconfig.ApiContainer;
import com.omni.ads.baseconfig.ApiException;
import com.omni.ads.baseconfig.Constant;
import com.omni.ads.baseconfig.ResultDto;
import com.omni.ads.api.AdsInstantAppApi;
import com.omni.ads.exception.OmniAdsResponseException;
import com.omni.ads.model.adsinstantapp.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

public class AdsInstantAppApiContainer extends ApiContainer {
    @Inject
    AdsInstantAppApi api;
    private static final Logger LOGGER = LoggerFactory.getLogger(AdsInstantAppApiContainer.class);

    /**
     * 查询快应用相关信息
     *
     * @param data
     * @return HttpResponse<AdInstantAppVo>
     * @api
     */
    public ResultDto<AdInstantAppVo> v2CommunalInstantAppInfo(@Validated @ModelAttribute AdInstantAppForm data) throws ApiException, OmniAdsResponseException {
        ResultDto<AdInstantAppVo> rt = new ResultDto<>();
        try {
            AdsQueryInsAppResponse resp = api.queryInsApp(data);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalInstantAppInfo exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 查询快应用键入历史
     *
     * @param inputAppId
     * @return HttpResponse<List < AdInstantAppVo>>
     * @api
     */
    public ResultDto<List<AdInstantAppVo>> v2CommunalInstantListHistoryAppInfo(@RequestParam(value = "inputAppId", required = false) Integer inputAppId) throws ApiException, OmniAdsResponseException {
        ResultDto<List<AdInstantAppVo>> rt = new ResultDto<>();
        try {
            AdsQueryInsAppHistoryResponse resp = api.queryInsAppHistory(inputAppId);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalInstantListHistoryAppInfo exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 校验并返回快应用相关信息
     * */
    public ResultDto<AdInstantAppVo> v3CommunalInstantCheck(@Validated AdV3InstantAppForm form){
        ResultDto<AdInstantAppVo> rt = new ResultDto<>();
        try {
            AdsQuickAppResponse resp = api.quickApp(form);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3CommunalInstantCheck exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }
}

