package com.omni.ads.container;

import com.google.gson.JsonSyntaxException;
import com.google.inject.Inject;
import com.omni.ads.baseconfig.ApiContainer;
import com.omni.ads.baseconfig.ApiException;
import com.omni.ads.baseconfig.Constant;
import com.omni.ads.baseconfig.ResultDto;
import com.omni.ads.api.AdsMaterialApi;
import com.omni.ads.exception.OmniAdsResponseException;
import com.omni.ads.model.adscreativity.vo.AdsAdMaterialVo;
import com.omni.ads.model.adsdata.AdsDataResponse;
import com.omni.ads.model.material.*;
import com.omni.ads.model.material.vo.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;

public class AdsMaterialApiContainer extends ApiContainer {
    @Inject
    AdsMaterialApi api;
    private static final Logger LOGGER = LoggerFactory.getLogger(AdsMaterialApiContainer.class);

    /**
     * 获取素材规格
     *
     * @param data
     * @return
     * @api
     */
    public ResultDto<List<AdsMtrSpecVo>> v2CommunalMaterialSpecList(AdsMtrSpecForm data) throws ApiException, OmniAdsResponseException {
        ResultDto<List<AdsMtrSpecVo>> rt = new ResultDto<>();
        try {
            AdsMaterialSpecQueryResponse resp = api.queryMaterialSpec(data);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalMaterialSpecList exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 查询showType相关信息
     *
     * @param showType
     * @return
     * @api
     */
    public ResultDto<AdsShowTypeVo> v2CommunalMaterialShowTypeGet(Integer showType) throws ApiException, OmniAdsResponseException {
        ResultDto<AdsShowTypeVo> rt = new ResultDto<>();
        try {
            AdsMaterialgetShowTypeResponse resp = api.queryShowType(showType);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalMaterialShowTypeGet exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 获取模板列表
     *
     * @param data
     * @return HttpResponse<List < AdsH5TemplateVo>>
     * @api
     */
    public ResultDto<List<AdsH5TemplateVo>> v3CommunalH5Template(AdsV3H5TemplateForm data) throws ApiException, OmniAdsResponseException {
        ResultDto<List<AdsH5TemplateVo>> rt = new ResultDto<>();
        try {
            AdsMaterialGetH5TemplateResponse resp = api.getH5Template(data);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2communalMaterialH5TemplateList exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 获取图片列表
     *
     * @param data
     * @return HttpResponse<List < AdsAdMaterialVo>>
     * @api
     */
    public ResultDto<List<AdsAdMaterialVo>> v2CommunalMaterialList(AdsAdMaterialVo data) throws ApiException, OmniAdsResponseException {
        ResultDto<List<AdsAdMaterialVo>> rt = new ResultDto<>();
        try {
            AdsMaterialPictureResponse resp = api.getListMaterialPicture(data);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalMaterialList exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 分页获取广告主素材
     *
     * @param data
     * @return HttpResponse<Page < AdsAdMaterialVo>>
     * @api
     */
    public ResultDto<Page<AdsAdMaterialVo>> v2CommunalMaterialPageList(AdsAdMaterialForm data) throws ApiException, OmniAdsResponseException {
        ResultDto<Page<AdsAdMaterialVo>> rt = new ResultDto<>();
        try {
            AdsMaterialPageListResponse resp = api.getMaterialPageList(data);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalMaterialPageList exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 创意中心-统一上传接口
     */
    public ResultDto<Object> v3MaterialCommunalUpload(AdsMtFileForm map) throws ApiException, OmniAdsResponseException {
        ResultDto<Object> rt = new ResultDto<>();
        try {
            AdsDataResponse resp = api.materialCommunalUpload(map);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3AgencyQueryQueryAgentQuickGame exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        } catch (JsonSyntaxException e1) {
            return rt;
        }
    }

    /**
     * 创意中心-素材统一查询接口
     */
    public ResultDto<Object> v3MaterialCommunalQuery(Map<String,Object> map) throws ApiException, OmniAdsResponseException {
        ResultDto<Object> rt = new ResultDto<>();
        try {
            AdsDataResponse resp = api.getQueryMt(map);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3MaterialCommunalQuery exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        } catch (JsonSyntaxException e1) {
            return rt;
        }
    }

    /**
     * 创意中心-上传素材到素材库
     */

    public ResultDto<Object> v3MaterialCommunalUploadDepot(AdsMtForm map) throws ApiException, OmniAdsResponseException {
        ResultDto<Object> rt = new ResultDto<>();
        try {
            AdsDataResponse resp = api.uploadDepot(map);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3MaterialCommunalUploadDepot exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        } catch (JsonSyntaxException e1) {
            return rt;
        }
    }

}

