package com.omni.ads.container;

import com.google.inject.Inject;
import com.omni.ads.baseconfig.ApiContainer;
import com.omni.ads.baseconfig.ApiException;
import com.omni.ads.baseconfig.Constant;
import com.omni.ads.baseconfig.ResultDto;
import com.omni.ads.api.AdsOwnerApi;
import com.omni.ads.exception.OmniAdsResponseException;
import com.omni.ads.model.adsconfig.HttpResponse;
import com.omni.ads.model.adsowner.*;
import com.omni.ads.model.adsowner.vo.AdsOwner;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

public class AdsOwnerApiContainer extends ApiContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdsOwnerApiContainer.class);

    @Inject
    AdsOwnerApi api;

    /**
     * 用户基础信息接口,获取当前登陆态子客户信息,登陆态用户为子客户才行
     *
     * @return
     * @api
     */
    public ResultDto<AdsOwnerVo> v2CommunalOwnerInfo() throws ApiException, OmniAdsResponseException {
        ResultDto<AdsOwnerVo> rt = new ResultDto<>();
        try {
            AdsOwnerInfoResponse resp = api.getAdsInfo();
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalOwnerInfo exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 子客户、直客 自身客户信息查询
     *
     * @return
     */
    public  ResultDto<AdsCustomerInfoForm> v2CommunalOwnerCustomerInfoGet() throws ApiException, OmniAdsResponseException {
        ResultDto<AdsCustomerInfoForm> rt = new ResultDto<>();
        try {
            AdsCustomerInfoResponse resp = api.getCustomerInfo();
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalOwnerCustomerInfoGet exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 直客 自身客户信息编辑
     * <p>
     * 子客户只能由代理商编辑
     *
     * @param data
     * @return
     */
    public ResultDto<HttpResponse> v2CommunalOwnerCustomerInfoGetEdit(AdsCustomerInfoForm data) throws ApiException, OmniAdsResponseException {
        ResultDto<HttpResponse> rt = new ResultDto<>();
        try {
            AdsCustomerInfoEditResponse resp = api.editCustomerInfo(data);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalOwnerCustomerInfoGetEdit exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 上传从账户的营业执照
     * <p>
     * 此接口已被拓展，不仅支持营业执照上传
     * 可支持@see ImageUploadUtils指定的所有文件上传
     *
     * @param file
     * @param ownerId
     * @return
     * @throws Exception
     */
    public ResultDto<String> v2CommunalOwnerCustomerUploadBusiLicenceImg(MultipartFile file, Long ownerId, String uploadType) throws ApiException, OmniAdsResponseException {
        ResultDto<String> rt = new ResultDto<>();
        try {
            AdsUploadImgResponse resp = api.uploadBusiLicenceImg(file, ownerId, uploadType);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalOwnerCustomerUploadBusiLicenceImg exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     *设置账户日预算
     * @param accDayBudget 日预算
     * @param budgetType 预算类型
     * @return
     * @throws Exception
     */
    @ApiImplicitParams({@ApiImplicitParam(name = "accDayBudget", value = "账户日预算（分）, 账户日预算设置，不限默认传0, 最大日预算为")})
    @ApiOperation(value="客户日预算设置", notes = "设置账户日预算", httpMethod = "POST", consumes = MediaType.APPLICATION_FORM_URLENCODED_VALUE)
    public ResultDto<Void> v2CommunalOwnerSetAccDayBudget(@RequestParam(value = "accDayBudget", required = false) @ApiParam(value = "账户日预算额度") Long accDayBudget,
                                                          @RequestParam(value = "budgetType", required = false) @ApiParam(value = "账户日预算类型，0：额度不限") Integer budgetType) throws ApiException, OmniAdsResponseException {
        ResultDto<Void> rt = new ResultDto<>();
        try {
            AdsAccBudgetResponse resp = api.adsSetAccBudget(accDayBudget, budgetType);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalOwnerSetAccDayBudget exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 新增用户资质
     *
     * @param form
     * @return
     */
    public ResultDto<AdsQualificationForm> v2CommunalOwnerCustomerQualificationAdd(AdsQualificationForm form) throws ApiException, OmniAdsResponseException {
        ResultDto<AdsQualificationForm> rt = new ResultDto<>();
        try {
            AdsQualificationResponse resp = api.qualificationAdd(form);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalOwnerCustomerQualificationAdd exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 编辑用户资质
     *
     * @param form
     * @return
     */
    public ResultDto<AdsQualificationForm> v2CommunalOwnerCustomerQualificationEdit(AdsQualificationForm form) throws ApiException, OmniAdsResponseException {
        ResultDto<AdsQualificationForm> rt = new ResultDto<>();
        try {
            AdsQualificationResponse resp = api.qualificationEdit(form);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalOwnerCustomerQualificationEdit exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 查询用户资质
     *
     * @return
     */
    public ResultDto<AdsQualificationForm> v2QualificationGet() throws ApiException, OmniAdsResponseException {
        ResultDto<AdsQualificationForm> rt = new ResultDto<>();
        try {
            AdsQualificationResponse resp = api.qualificationGet();
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2QualificationGet exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

}

