/*
 * Marketing API
 * Marketing API
 *
 * OpenAPI spec version: 1.3
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.omni.ads.container;

import com.google.inject.Inject;
import com.omni.ads.baseconfig.ApiContainer;
import com.omni.ads.baseconfig.ApiException;
import com.omni.ads.baseconfig.Constant;
import com.omni.ads.baseconfig.ResultDto;
import com.omni.ads.api.AdsPlanApi;
import com.omni.ads.exception.OmniAdsResponseException;
import com.omni.ads.model.adscreativity.AdsAdDataResp;
import com.omni.ads.model.adscreativity.vo.HttpPage;
import com.omni.ads.model.adsgroup.ValidationGroup;
import com.omni.ads.model.adsplan.*;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.groups.Default;
import java.util.List;

public class AdsPlanApiContainer extends ApiContainer {

    @Inject
    AdsPlanApi api;
    private static final Logger LOGGER = LoggerFactory.getLogger(AdsPlanApiContainer.class);

    /**
     * 创建单个广告计划信息
     *
     * @param planForm (required)
     * @return AdsPlanAddResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ResultDto<AdsPlanAddResp> v3PlanAdd(@Validated @ModelAttribute AdsPlanAddForm planForm) throws ApiException, OmniAdsResponseException {
        ResultDto<AdsPlanAddResp> rt = new ResultDto<>();
        try {
            AdsAddPlanResponse resp = api.addAdsPlan(planForm);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3PlanAdd exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }


    /**
     * 删除广告计划
     *
     * @param planIds (required)
     * @return AdsPlanUpdateInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ResultDto<List<AdsPlanUpdateInfo>> v3PlanDelete(@RequestParam(required = false) @ApiParam(value = "计划Id列表", required = true) List<Long> planIds)
            throws ApiException, OmniAdsResponseException {
        ResultDto<List<AdsPlanUpdateInfo>> rt = new ResultDto<>();
        try {
            AdsPlanDeleteResponse resp = api.adsPlanDelete(planIds);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3PlanDelete exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 获取单个广告计划信息
     *
     * @param planId (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ResultDto<AdsPlanDataResp> v3PlanGet(@RequestParam(required = false) @ApiParam(value = "计划Id", required = true) Long planId) throws ApiException, OmniAdsResponseException {
        ResultDto<AdsPlanDataResp> rt = new ResultDto<>();
        try {
            AdsGetPlanResponse resp = api.adsGetPlan(planId);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3PlanGet exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 编辑单个广告计划信息
     *
     * @param planForm (required)
     * @return AdsPlanUpdateInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     */
    public ResultDto<AdsPlanUpdateInfo> v3PlanEdit(@Validated @ModelAttribute AdsPlanEditForm planForm) throws ApiException, OmniAdsResponseException {
        ResultDto<AdsPlanUpdateInfo> rt = new ResultDto<>();
        try {
            AdsEditPlanResponse resp = api.editAdsPlan(planForm);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3PlanEdit exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }

    }

    /**
     * 批量设置或修改日预算
     *
     * @param planForm (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     * @returnHttpResponse<List<AdsPlanUpdateInfo>>
     */
    public ResultDto<List<AdsPlanUpdateInfo>> v3PlanDayBudget(@Validated @ModelAttribute AdsPlanBudgetForm planForm) throws ApiException, OmniAdsResponseException {
        ResultDto<List<AdsPlanUpdateInfo>> rt = new ResultDto<>();
        try {
            AdsBatchEditBudgetResponse resp = api.batchUpdateBudget(planForm);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3PlanDayBudget exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 批量设启停广告计划
     *
     * @param planForm (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     * @returnHttpResponse<List<AdsPlanUpdateInfo>>
     */
    public ResultDto<List<AdsPlanUpdateInfo>> v3PlanStatus(@Validated @ModelAttribute AdsPlanStatusForm planForm) throws ApiException, OmniAdsResponseException {
        ResultDto<List<AdsPlanUpdateInfo>> rt = new ResultDto<>();
        try {
            AdsBatchEditBudgetResponse resp = api.batchUpdateStatu(planForm);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3PlanStatus exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 分页查询广告计划表
     *
     * @param data (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *                      response body
     * @returnHttpResponse<List<AdsPlanUpdateInfo>>
     */
    public ResultDto<HttpPage<AdsAdDataResp>> v3PlanPage(@Validated(value = {ValidationGroup.Find.class, Default.class})
                                                         @ModelAttribute AdsPlanDataReq data) throws ApiException, OmniAdsResponseException {
        ResultDto<HttpPage<AdsAdDataResp>> rt = new ResultDto<>();
        try {
            AdsGetPlanPageListResponse resp = api.getPlanPageList(data);
            rt.setData(resp.getData());
            rt.setRet(resp.getCode());
            rt.setMsg(resp.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3PlanPage exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

}

