package com.omni.ads.container;

import com.google.inject.Inject;
import com.omni.ads.api.AdsSearchKeyWordApi;
import com.omni.ads.baseconfig.ApiContainer;
import com.omni.ads.baseconfig.ApiException;
import com.omni.ads.baseconfig.Constant;
import com.omni.ads.baseconfig.ResultDto;
import com.omni.ads.model.adscreativity.AdsBatchReplicateResponse;
import com.omni.ads.model.adssearchkeyword.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;

import java.util.List;

public class AdsSearchKeyWordContainer extends ApiContainer {
    @Inject
    AdsSearchKeyWordApi api;
    private static final Logger LOGGER = LoggerFactory.getLogger(AdsSearchKeyWordContainer.class);

    /**
     * 查询行业词包
     *
     * @param listDTO 行业词查询过滤器
     * @return
     */
    public ResultDto<List<AdSearchCategoryKwResultDTO>> v3CommunalSearchKeyWordListCategoryKws(AdSearchCategoryKwQueryDTO listDTO){
        ResultDto<List<AdSearchCategoryKwResultDTO>> rt = new ResultDto<>();
        try {
            AdsQueryIndustryWordsResponse response = api.queryIndustryWord(listDTO);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3CommunalSearchKeyWordlistCategoryKws exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 查询出价词
     *
     * @param listKwsDTO 出价词过滤器
     * @return 出价词 dto
     */
    public ResultDto<List<AdSearchPremiumKwResultDTO>> v3CommunalSearchKeyWordListPremiumKws(AdSearchPremiumKwQueryDTO listKwsDTO){
        ResultDto<List<AdSearchPremiumKwResultDTO>> rt = new ResultDto<>();
        try {
            AdsQueryPriceWordsResponse response = api.queryPriceWord(listKwsDTO);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3CommunalSearchKeyWordListPremiumKws exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }

    }

    /**
     * 查询广告主所有自定义词包
     *
     * @param premiumCustomKwDTO
     * @return
     */
    public ResultDto<List<PremiumCustomKw>> v3CommunalSearchKeyWordQueryPackageByOwner(PremiumCustomKwDTO premiumCustomKwDTO){
        ResultDto<List<PremiumCustomKw>> rt = new ResultDto<>();
        try {
            AdsQueryPackageResponse response = api.queryPackage(premiumCustomKwDTO);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3CommunalSearchKeyWordQueryPackageByOwner exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 查询广告组下的关键词、行业类目词包、自定义词包或禁推词包
     * */

    public ResultDto<List<AdSearchPremiumKwResultDTO>> v3ListGroupKwPkg(@Validated ListGroupKwPkgForm listGroupKwPkgForm){
        ResultDto<List<AdSearchPremiumKwResultDTO>> rt = new ResultDto<>();
        try {
            AdsQueryPriceWordsResponse response = api.queryKeyWords(listGroupKwPkgForm);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3ListGroupKwPkg exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }

    }

    /**
     * 新增自定义词包，禁推词包
     * */
    public ResultDto<Void> v3AddCustomOrNoKwPkg(@Validated AddCustomKwPkgForm kwPackageForm){
        ResultDto<Void> rt = new ResultDto<>();
        try {
            AdsAddDefineWordsResponse response = api.addKeyWords(kwPackageForm);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3AddCustomOrNoKwPkg exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }

    }

    /**
     * 删除自定义词包、禁推词包中的关键词
     * */
    public ResultDto<Void> v3DeleteKwInPkg(@Validated DeleteKwInPkgForm kwPackageForms){
        ResultDto<Void> rt = new ResultDto<>();
        try {
            AdsAddDefineWordsResponse response = api.delKeyWords(kwPackageForms);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3DeleteKwInPkg exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 为已经存在的自定义词包、禁推词包添加关键词
     * */
    public ResultDto v3AddKwToPkg(@Validated AddKwToPkgForm kwPackageForms){
        ResultDto rt = new ResultDto<>();
        try {
            AdsBatchReplicateResponse response = api.addKeyWordsToPkg(kwPackageForms);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3AddKwToPkg exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 编辑自定义词包、禁推词包词包名称，编辑词包中关键词的匹配模式
     * */
    public ResultDto v3EditCustomOrNoKwPkg(@Validated EditKwPkgForm editKwPkgForm){
        ResultDto rt = new ResultDto<>();
        try {
            AdsBatchReplicateResponse response = api.editCustomOrNoKwPkg(editKwPkgForm);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3EditCustomOrNoKwPkg exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 通过词包ID删除自定义词包、禁推词包，词包与广告组的绑定关系也会删除
     * */

    public ResultDto v3BatchDeleteKwPkg(@Validated BatchDeleteKwPkgForm kwPkgForm){
        ResultDto rt = new ResultDto<>();
        try {
            AdsBatchReplicateResponse response = api.batchDeleteKwPkg(kwPkgForm);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3BatchDeleteKwPkg exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 广告组绑定关键词、行业类目词包、自定义/禁推词包
     * */

    public ResultDto v3AddGroupKw(@Validated AddGroupKwForm form){
        ResultDto rt = new ResultDto<>();
        try {
            AdsBatchReplicateResponse response = api.addGroupKw(form);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3AddGroupKw exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 广告组删除关键词、行业类目词包、自定义/禁推词包
     * */
    public ResultDto v3DeleteGroupKw(@Validated DeleteGroupKwForm form){
        ResultDto rt = new ResultDto<>();
        try {
            AdsBatchReplicateResponse response = api.delGroupKw(form);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3DeleteGroupKw exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 广告组编辑关键词、行业类目词包、自定义词包价格
     * */
    public ResultDto v3EditGroupKw(@Validated EditGroupKwForm form){
        ResultDto rt = new ResultDto<>();
        try {
            AdsBatchReplicateResponse response = api.editGroupKw(form);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3EditGroupKw exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 根据packageId查询自定义词包里的词
     * */
    public ResultDto<List<PremiumCustomKwDTO>> v3QueryByKwPackageId(PremiumCustomKwDTO premiumCustomKwDTO){
        ResultDto<List<PremiumCustomKwDTO>> rt = new ResultDto<>();
        try {
            AdsQueryPackageDTOResponse response = api.queryByKwPackageId(premiumCustomKwDTO);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v3QueryByKwPackageId exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }
}

