package com.omni.ads.container;

import com.google.gson.JsonSyntaxException;
import com.google.inject.Inject;
import com.omni.ads.api.AdsTargetApi;
import com.omni.ads.baseconfig.ApiContainer;
import com.omni.ads.baseconfig.ApiException;
import com.omni.ads.baseconfig.Constant;
import com.omni.ads.baseconfig.ResultDto;
import com.omni.ads.exception.OmniAdsResponseException;
import com.omni.ads.model.adscreativity.vo.Groups;
import com.omni.ads.model.adsdata.AdsDataResponse;
import com.omni.ads.model.adstarget.*;
import com.omni.ads.model.material.AdsMtFileForm;
import com.omni.ads.model.material.AdsMtForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

public class AdsTargetApiContainer extends ApiContainer {
    @Inject
    AdsTargetApi api;
    private static final Logger LOGGER = LoggerFactory.getLogger(AdsTargetApiContainer.class);

    /**
     * 新增定向
     */
    public ResultDto<AdsTargetVo> v2CommunalTargetAdd(AdsTargetVo vo) throws Exception {
        ResultDto<AdsTargetVo> rt = new ResultDto<>();
        try {
            AdsAddTargetResponse response = api.addTarget(vo);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalTargetAdd exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 获取定向
     */
    public ResultDto<AdsTargetVo> v2CommunalTargetGet(AdsTargetForm targetForm) throws Exception {
        ResultDto<AdsTargetVo> rt = new ResultDto<>();
        try {
            AdsAddTargetResponse response = api.getTarget(targetForm);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalTargetGet exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 删除定向
     */
    public ResultDto<Integer> v2CommunalTargetDel(AdsTargetForm form) throws Exception {
        ResultDto<Integer> rt = new ResultDto<>();
        try {
            AdsDelTargetResponse response = api.delTarget(form);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalTargetDel exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 修改定向
     */
    public ResultDto<AdsTargetVo> v2CommunalTargetUpdate(@Validated(value = {Groups.Edit.class}) AdsTargetVo vo) throws Exception {
        ResultDto<AdsTargetVo> rt = new ResultDto<>();
        try {
            AdsAddTargetResponse response = api.editTarget(vo);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalTargetUpdate exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 获取定向列表
     */
    public ResultDto<List<AdsTargetVo>> v2CommunalTargetList(TargetFilterVo param) throws Exception {
        ResultDto<List<AdsTargetVo>> rt = new ResultDto<>();
        try {
            AdsTargetListResponse response = api.targetList(param);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalTargetList exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 查询定向元数据接口,定向相关数据&用户权限
     */
    public ResultDto<AdsTargetMetadataVo> v2CommunalTargetGetMetadataAppList(
            @RequestParam(required = false, value = "showType") Integer showType,
            @RequestParam(required = false, value = "extensionType") Integer extensionType,
            @RequestParam(required = false, value = "isTop") boolean isTop,
            @RequestParam(required = false, value = "flowScene") Integer flowScene) throws Exception {
        ResultDto<AdsTargetMetadataVo> rt = new ResultDto<>();
        try {
            AdsQueryDataResponse response = api.queryData(showType, extensionType, flowScene, isTop);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalTargetGetMetadataAppList exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 获取元数据
     */
    public ResultDto<AdsTargetMetadataVo> v2CommunalTargetGetMetadata(
            @RequestParam(required = false, value = "showType") Integer showType,
            @RequestParam(required = false, value = "extensionType") Integer extensionType,
            @RequestParam(required = false, value = "flowScene") Integer flowScene) throws Exception {
        ResultDto<AdsTargetMetadataVo> rt = new ResultDto<>();
        try {
            AdsQueryDataResponse response = api.getMetadata(showType, extensionType, flowScene);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2CommunalTargetGetMetadata exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 获取查询联盟App元数据列表(支持分页+搜索).
     *
     * @return
     */
    public ResultDto<AdsTargetMetadataVo> v2NewUappList(AdsUAppQueryForm uAppQueryForm) {
        ResultDto<AdsTargetMetadataVo> rt = new ResultDto<>();
        try {
            AdsAppMetadataResponse response = api.getAppMetadata(uAppQueryForm);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2NewUappList exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * 用户兴趣标签新版本
     *
     * @param showType
     * @return
     */
    public ResultDto<List<AdsAdAppInterestTagVo>> getUserInterestTagV2(@RequestParam(required = false, value = "showType") Integer showType,
                                                                       @RequestParam(required = false, value = "extensionType") Integer extensionType,
                                                                       @RequestParam(required = false, value = "flowScene") Integer flowScene) {
        ResultDto<List<AdsAdAppInterestTagVo>> rt = new ResultDto<>();
        try {
            AdsGetTagsResponse response = api.gettags(showType, extensionType, flowScene);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("getUserInterestTagV2 exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        }
    }

    /**
     * IMEI文件上传
     */

    public ResultDto<Object> v2TargetImeiUpload(AdsTargetImeiForm map) throws ApiException, OmniAdsResponseException {
        ResultDto<Object> rt = new ResultDto<>();
        try {
            AdsDataResponse response = api.imeiUpload(map);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2TargetImeiUpload exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        } catch (JsonSyntaxException e1) {
            return rt;
        }
    }

    /**
     * 运算人群包（人群包交并）
     */

    public ResultDto<Object> v2TargetAddExpansionTask(AdsTargetTaskForm data) throws ApiException, OmniAdsResponseException {
        ResultDto<Object> rt = new ResultDto<>();
        try {
            AdsDataResponse response = api.addExpansionTask(data);
            rt.setData(response.getData());
            rt.setRet(response.getCode());
            rt.setMsg(response.getMessage());
            return rt;
        } catch (ApiException e) {
            LOGGER.info("v2TargetAddExpansionTask exception", e);
            rt.setRet(Constant.EXCUTE_FAIL);
            rt.setMsg("链接超时");
            return rt;
        } catch (JsonSyntaxException e1) {
            return rt;
        }
    }
}

