package com.omni.ads.examples.ad;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.omni.ads.baseconfig.OmniAds;
import com.omni.ads.baseconfig.ResultDto;
import com.omni.ads.examples.TestConfig;
import com.omni.ads.exception.OmniAdsResponseException;
import com.omni.ads.model.adscreativity.AdsAdCollectBatchReq;
import com.omni.ads.model.adscreativity.vo.AdsAdCollectReq;

import java.util.*;

/**
 * 批量操作广告创意
 */
public class BatchOprateAds {

    public ResultDto<Set<Long>> batchAd() throws Exception {
        OmniAds omniAds = TestConfig.getOmniAPI();
        //设置必要参数  data.setxxx 详情见文档
        AdsAdCollectBatchReq data = new AdsAdCollectBatchReq();
        List<AdsAdCollectReq> adList = new ArrayList<>();
        List<Long> matIdsList = new ArrayList<>();
        AdsAdCollectReq ads = new AdsAdCollectReq();
        ads.setAdGroupId(300479675L);
        ads.setAdPlanId(200295552L);
        ads.setAdName("ljr-mapi-3月18号15点09");
        ads.setAdSource(1);
        ads.setBrandLogoImgId(1912186L);
        ads.setBrandName("淘宝");
        ads.setButtonTxt("打开");
        ads.setCopywriter("通知栏中图");
        ads.setContent("通知栏中图内容");
        ads.setDynamicCr(0);
        ads.setGlobalSpecId(1);
        matIdsList.add(44246836L);
        ads.setImgMatIds(matIdsList);

        adList.add(ads);
        data.setAddList(adList);
        ResultDto<Set<Long>> res = omniAds.ads().v3AdBatch(data);
        return res;
    }

    public static void main(String[] args) {
        try {
            BatchOprateAds entity = new BatchOprateAds();
            ResultDto<Set<Long>> response = entity.batchAd();
            System.out.println(JSON.toJSONString(response, SerializerFeature.PrettyFormat));
        } catch (OmniAdsResponseException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}

