package com.omni.ads.examples.ad;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.omni.ads.baseconfig.OmniAds;
import com.omni.ads.baseconfig.ResultDto;
import com.omni.ads.examples.TestConfig;
import com.omni.ads.exception.OmniAdsResponseException;
import com.omni.ads.model.adscreativity.AdsAdCollectResp;

/**
 * 获取单个广告创意
 */
public class GetCreativityAds {

    ResultDto<AdsAdCollectResp> getAd() throws Exception {
        OmniAds omniAds = TestConfig.getOmniAPI();
        //设置必要参数  data.setxxx 详情见文档
        ResultDto<AdsAdCollectResp> res = omniAds.ads().v3AdGet(401089610L);
        return res;
    }

    public static void main(String[] args) {
        try {
            GetCreativityAds entity = new GetCreativityAds();
            ResultDto<AdsAdCollectResp> response = entity.getAd();
            System.out.println(JSON.toJSONString(response, SerializerFeature.PrettyFormat));
        } catch (OmniAdsResponseException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}

