package com.omni.ads.examples.communal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.omni.ads.baseconfig.OmniAds;
import com.omni.ads.baseconfig.ResultDto;
import com.omni.ads.examples.TestConfig;
import com.omni.ads.exception.OmniAdsResponseException;
import com.omni.ads.model.adscommunal.AdsConfigReq;
import com.omni.ads.model.adscommunal.AdsConfigResp;

import java.util.List;

/**
 * 根据配置类型获取配置项
 */
public class V3CommunalConfigGetList {

    public ResultDto<List<AdsConfigResp>> getConfigList() throws Exception {
        OmniAds omniAds = TestConfig.getOmniAPI();
        //设置必要参数  data.setxxx 详情见文档
        AdsConfigReq data = new AdsConfigReq();
        data.setType("EXTENSION_TYPE");
        ResultDto<List<AdsConfigResp>> res = omniAds.adsCommunal().v3CommunalConfigGetList(data);
        return res;
    }

    public static void main(String[] args) {
        try {
            V3CommunalConfigGetList entity = new V3CommunalConfigGetList();
            ResultDto<List<AdsConfigResp>> response = entity.getConfigList();
            System.out.println(JSON.toJSONString(response, SerializerFeature.PrettyFormat));
        } catch (OmniAdsResponseException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}


