package com.omni.ads.examples.communal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.omni.ads.baseconfig.OmniAds;
import com.omni.ads.baseconfig.ResultDto;
import com.omni.ads.examples.TestConfig;
import com.omni.ads.exception.OmniAdsResponseException;
import com.omni.ads.model.adscommunal.AdsConfigReq;
import com.omni.ads.model.adscommunal.AdsConfigResp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 根据配置类型批量获取配置项
 */
public class V3CommunalConfigGetMap {

    public ResultDto<Map<String, List<AdsConfigResp>>> getConfigMap() throws Exception {
        OmniAds omniAds = TestConfig.getOmniAPI();
        AdsConfigReq data = new AdsConfigReq();
        List<String> list = new ArrayList<>();
        list.add("DEEP_OCPC_TYPE");
        list.add("OCPC_TYPE");
        list.add("SPEC_TYPE");
        data.setTypeList(list);
        data.setExtensionType(2);
        data.setExtensionFlow(2);
        data.setFlowScene(6);
        ResultDto<Map<String, List<AdsConfigResp>>> response = omniAds.adsCommunal().v3CommunalConfigGetMap(data);
        return response;
    }

    public static void main(String[] args) {
        try {
            V3CommunalConfigGetMap entity = new V3CommunalConfigGetMap();
            ResultDto<Map<String, List<AdsConfigResp>>> response = entity.getConfigMap();
            System.out.println(JSON.toJSONString(response, SerializerFeature.PrettyFormat));
        } catch (OmniAdsResponseException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}

